// ZEUS! : <PRUEBA.C>

// Programa para comprobar la forma de sincronizar procesos por medio
// de mensajes.
//#include <conio.h>	// E/S consola.
#include <dos.h>	// setvect
//#include <stdlib.h>	// Nmero aleatorios.
//#include <stdio.h>	// sprintf
#include <string.h>	// Cadenas.
#include <process.h>	// exit
#include "defines.h"	// Definiciones de 	ZEUS!
#include "tipos.h"	// Tipos de 		ZEUS!
#include "ZEUS.H"	// Servicios de 	ZEUS!
#include "memoria.h"	// Gestor de memoria.
#include "ZGM\zmem.h"
#include "ZGM\TiposMem.h"
#include "ZGM\mem.h"
#include "ZGM\ErrorMem.h"
#include "ZSF\ctrdisco.h"
#include "ZSF\error.h"
#include "ZGT\tipos.h"
#include "ZGT\teclado.h"
#include "ZGT\zgt.h"
extern tpEBCP far *Activo; /* El BPC activo */
extern tpEBCP far *BCPs; /* Lista de BCP's */


/* Variable que indica si se sali correctamente de ZEUS */
char SalidaCorrecta = 0; /* Estar a falso si no se ha de salir */

/* Identificadores de procesos de cada proceso */
TZIP	ZSF;	        // Zeus Sistema de Ficheros
TZIP	ZeusShell;	// Zeus Shell
TZIP	ZeusTerminal;   // Si ste proceso se ejecuta, ZEUS termina.
TZIP    ZeusVersion;    // devuelve la version Actual del Zeus.
TZIP    ZGM;            // Gestor de memoria del Zeus.
TZIP    ZGT;            // Gestor de Teclado y Video de Zeus.
/***************** DEBUG ****************************/
unsigned _unsigned( unsigned N );
unsigned _unsigned( unsigned N ) { return N; }

char *DameEstado(unsigned Num)
 {
   switch(Num){
    case 0: return("ACTIVO");
    case 1: return("PREPARADO");
    }
   return("BLOQUEADO");
 }

void Muestra_Lista_BCPs( void );
void Muestra_Lista_BCPs( void ) {
 tpEBCP far *I = BCPs;
 ZGT_Z_printf("\n");
 ZGT_Z_printf(" %20s %13s %11s Msg. S.P. %8s \n","Proceso","Prioridad","Estado","ZIP");
 ZGT_Z_printf("------------------------------------------------------------------------------\n");
 while( I ) {
  ZGT_Z_printf(" %20s %13u %11s %4u %04X %08lX\n",
	   I->BCP.Nombre,
	   _unsigned(I->BCP.Prioridad),
	   DameEstado(_unsigned(I->BCP.Estado)),
	   _unsigned(I->BCP.NMensajes),
	   _unsigned((unsigned)I->BCP.Servicio_Pendiente),
	   I->BCP.ZIP);
//  ZGT_Z_printf(" Joven:  %08lX  Viejo: %08lX\n",I->BCP.Joven,I->BCP.Viejo);
  I = I->Despues;
 }
 ZGT_Z_printf("\n\n");
}
/****************************************************/

void PZSF( void );
void PZeusTerminal( void );
void PZeusShell( void );
void PZeusVersion( void );
void PZGM( void );
void PZGT( void );

void proceso_inicializador_de_ZEUS() {

 Z_printf("\n\r");
 Z_printf("  \n");
 Z_printf("  ͻ\n");
 Z_printf("                                                                             \n");
 Z_printf("          ZEUS Operating. System. By Zeus Group Corporation. (c) 1997.       \n");
 Z_printf("                                                                             \n");
 Z_printf("      Jos Luis Vela             made in             Jose Juan Barco         \n");
 Z_printf("      Javier Cuevas                                  Oscar Garca            \n");
 Z_printf("                                E.U.P.L.A.                                   \n");
 Z_printf("                                                                             \n");
 Z_printf("   Pulse una tecla para cargar  ZEUS ͼ\n");
 Z_printf("  ۲ \n");
 Z_printf("\n");
 Z_getch();

// directvideo = 1;
 ZSF          = ZEUS_nuevo_proceso( _CS, (unsigned)PZSF          , 50000,  50, "Servidor de ficheros");
 ZGT          = ZEUS_nuevo_proceso( _CS, (unsigned)PZGT          ,  8000,   5, "G.Teclado y Video"   );
 ZGM          = ZEUS_nuevo_proceso( _CS, (unsigned)PZGM          ,  8000,  10, "Gestor de memoria"   );
 ZeusTerminal = ZEUS_nuevo_proceso( _CS, (unsigned)PZeusTerminal ,  4000, 255, "Zeus Terminal"       );
 ZeusShell    = ZEUS_nuevo_proceso( _CS, (unsigned)PZeusShell    , 50000, 100, "Zeus Shell"          );
 ZeusVersion  = ZEUS_nuevo_proceso( _CS, (unsigned)PZeusVersion  ,  4000,  40, "Servidor de versin"      );


 ZEUS_terminar();
}

void _PZSF( void ); void PZSF() { _PZSF(); }
void _PZSF( void ) {
 tpZSFA far *Arg;
 unsigned Servicio;

 ZGT_Z_printf("       Inicializando Sistema de ficheros...");
 // La unidad a montar por defecto al inicializar el sistema es la A: o la 0 BIOS
 if( InicializaSistemaFicheros(0) != NO_ERROR ) {
  ZGT_Z_printf(" Error montando unidad. Saliendo...\n");
  ZEUS_terminar();
 }
 ZGT_Z_printf("Ok. Unidad montada sobre / \n");

 for(;;) { // Bucle infinito del servidor
  Arg = ( tpZSFA far * ) ZEUS_recibir_mensaje(); // Recibimos solicitud por el canal.
  Servicio=Arg->S;
  switch( Servicio ) {
   case 2 : Arg->S = CierraSistemaFicheros(); ZEUS_terminar(); break;
   case 3 : Arg->S = MontarUnidad( Arg->I, ( char far * )Arg->A ); break;
   case 4 : Arg->S = DesmontarUnidad(  ( char far * )Arg->A ); break;
   case 5 : Arg->S = AbrirFichero( (int far *)Arg->A,  ( char far * )Arg->B ); break;
   case 6 : Arg->S = CerrarFichero( Arg->I ); break;
   case 7 : Arg->S = LeerFichero( Arg->I, Arg->D,  ( char far * )Arg->A ); break;
   case 8 : Arg->S = EscribirFichero( Arg->I, Arg->D,  ( char far * )Arg->A ); break;
   case 9 : Arg->S = Situar( Arg->I, Arg->D ); break;
   case 10: Arg->D = LongFichero( Arg->I ); break;
   case 11: Arg->S = Eof( Arg->I ); break;
   case 12: Arg->S = CrearFichero(  ( char far * )Arg->A ); break;
   case 13: Arg->S = BorrarFichero(  ( char far * )Arg->A ); break;
   case 14: Arg->S = CrearDirectorio(  ( char far * )Arg->A ); break;
   case 15: Arg->S = BorrarDirectorio(  ( char far * )Arg->A ); break;
   case 16: Arg->S = NumEntradasEnDirectorio(  ( char far * )Arg->A, ( WORD far * )Arg->B ); break;
   case 17: Arg->S = ListaArchivos(  ( char far * )Arg->A, ( TpEntradaDir far * )Arg->B ); break;
   case 18: Arg->S = DameNombreFichero(  ( char far * )Arg->A, ( TpEntradaDir far * )Arg->B ); break;
   case 19: Arg->S = DameTipoFichero( ( char far * )Arg->A ); break;
   case 20: Arg->S = NumUnidadesMontadas(); break;
   case 21: DameUnidadesMontadas( ( TpInfoUnidadesMontadas far * )Arg->A ); break;
  }
 }
}

int Rebootar=0;

void _PZeusTerminal( void ); void PZeusTerminal() { _PZeusTerminal(); }
void _PZeusTerminal( void ) {
 static tpZSFA A = { 2, 0, 0, 0, 0, 0 };

 A.R=ZeusTerminal;
 ZGT_Z_printf("     Ejecutado el proceso ZEUS-TERMINAL. Cerrando el sistema...\n");
 ZGT_Z_printf("     Desmontando Sistema de ficheros...");
 ZEUS_enviar_mensaje( ZSF        , &A );
 if(A.S!=NO_ERROR)
   ZGT_Z_printf("     Error desmontando sistema de ficheros.\n");
  else
   ZGT_Z_printf("     Sistema de ficheros desmontado. \n");
 ZGT_Z_printf("     Saliendo del Zeus Shell...Ok\n");

 /* Por si salimos de manera poco ortodoxa */
  if( !SalidaCorrecta ) {
   asm { mov ax, 0x7; int 0x10 }; // Modo texto ( por si las moscas )
   ZGT_Z_printf("\n\n ERROR !!! ZEUS termin de manera incorrecta ( aunque parezca mentira ).\n");
   ZGT_Z_printf("Estado del gestor de memoria:\n");
   MuestraListaBCPMs( 0x1C, 0 );
   ZGT_Z_printf("Estado de la lista de BCP's:\n");
   Muestra_Lista_BCPs();
   ZGT_Z_printf("Sorry....");
  }

 /* Enviamos un kill al Servidor de version */
 A.S=1;
 ZEUS_enviar_mensaje( ZeusVersion, &A );

 // Cerramos el gestor de memoria
 A.S=1;
 ZEUS_enviar_mensaje( ZGM, &A );
 // Cerramos el gestor de memoria
 if(QuitaGestorMemoria()!= NO_ERROR)
   ZGT_Z_printf("     Error al remover la memoria.\n");

 // Cerramos el gestor de teclado y video
 A.S=1;
 ZEUS_enviar_mensaje( ZGT, &A );

 /* Miramos si hay que rebootar */
 switch( Rebootar) {
   case 1:  // Arranque en frio
    {
      unsigned long Boot = 0xFFFFFFF0;
      unsigned int far *BiosMem=(unsigned int far *)0x00400072L;
      *BiosMem=0x0000;
      ((void (far *)())Boot)();
      break;
    }
   case 2:  // Arranque en caliente
    {
      unsigned long Boot = 0xFFFFFFF0;
      unsigned int far *BiosMem=(unsigned int far *)0x00400072L;
      *BiosMem=0x1234;
      ((void (far *)())Boot)();
      break;
    }
   }
 /* Salimos al DOS */
 exit(0);
}

void _PZeusVersion( void ); void PZeusVersion() { _PZeusVersion(); }
void _PZeusVersion( void ) {
 tpZSFA far *Arg;
 int Salir=FALSE;
 static char far *Version=ZEUSVERSION;

 ZGT_Z_printf("       Kernel cargado: %s.\n",Version);
 while( !Salir ) {
     Arg = ( tpZSFA far * ) ZEUS_recibir_mensaje();
     switch(Arg->S) {
       case 0: /* Devolver puntero a cadena */
	 Arg->A=Version; break;
       case 1: /* Salir */
	 Salir=TRUE;
       }
   }
 /* Cuando se sale del bucle el proceso se termina */
 ZGT_Z_printf("     Zeus Version terminado.\n");

 // El proceso muere
 ZEUS_terminar();
 }

extern void Shell( void );

void _PZeusShell( void ); void PZeusShell() { _PZeusShell(); }
void _PZeusShell( void ) {

 ZGT_Z_printf(" -------------------------------------------------------------------------------\n");
 ZGT_Z_printf("        %s \n", VERSION );
 ZGT_Z_printf("            (Teclee ayuda para ver una lista de los comandos) \n\n");
 ZGT_Z_printf("                Memoria disponible en el sistema %lu bytes.\n\n",farcoreleft());
 ZGT_Z_printf(" -------------------------------------------------------------------------------\n\n");

 Shell();

 // El proceso muere.
 ZEUS_terminar();
}


void _PZGM( void ); void PZGM() { _PZGM(); }
void _PZGM( void ) {
 tpZSFA far *Arg;
 int Salir=FALSE;

 ZGT_Z_printf("       Inicializando Gestor de Memoria del Zeus.\n");
 MuestraListaBCPMs( 0x10, 0);
 while( !Salir ) {
     Arg = ( tpZSFA far * ) ZEUS_recibir_mensaje();
     switch(Arg->S) {
       case 1 : /* Cerrar GestorMemoria */
	 Salir=TRUE;
	 break;
       case 2 : /* Dame memoria */
	 Arg->A = AsignaMemoria( Arg->D, Arg->C, ( unsigned long ) Arg->A );
	 break;
       case 3 : /* Libera memoria */
	 LiberaMemoria( Arg->A );
	 break;
       case 4 : /* Memoria Disponible */
	 Arg->D= DameMemoriaDisponible( &Arg->S );
	 break;
       case 5 : /* Memoria Ocupada */
	 Arg->D= DameMemoriaOcupada( &Arg->S );
	 break;
       }
   }
   /* Cuando se sale del bucle el proceso se termina */
   ZGT_Z_printf("     Gestor de Memoria finalizado.\n");
   // El proceso muere
   ZEUS_terminar();
 }

void _PZGT( void ); void PZGT() { _PZGT(); }
void _PZGT( void ) {
 tpZSFA far *Arg;
 int Salir=FALSE;

 Z_printf("       Inicializando Gestor de teclado y video de Zeus.\n");
 while( !Salir ) {
     Arg = ( tpZSFA far * ) ZEUS_recibir_mensaje();
     switch(Arg->S) {
       case 1 : /* Cerrar GestorMemoria */
	 Salir=TRUE;
	 break;
       case 2 : /* Estado teclas */
	 Z_GetState((flags far *) Arg->A );
	 break;
       case 3 : /* Coge una cadena del teclado */
	 Z_gets( (char far *)Arg->A );
	 break;
       case 4 : /* setKey */
	 Arg->C=Z_Setkey( Arg->C );
	 break;
       case 5 : /* getch */
	 Arg->I=Z_getch( );
	 break;
       case 6 : /* Set Cursor */
	 Z_Setcursor(Arg->C,Arg->C2);
	 break;
       case 7 : /* CursorOn */
	 Z_Cursoron();
	 break;
       case 8 : /* CursroOff */
	 Z_Cursoroff();
	 break;
       case 9 : /* getch */
	 Z_SetCursorP(Arg->C,Arg->C2,Arg->C3);
	 break;
       case 10: /* getch */
	 Z_GetCursor(Arg->C,(char far *)Arg->A,(char far *)Arg->B,
			    (char far *)Arg->E,(char far *)Arg->R);
	 break;
       case 11: /* putch */
	 Z_putch(Arg->C,Arg->C2,Arg->C3);
	 break;
       case 12: /* puts */
	 Z_puts((char far *)Arg->A);
	 break;
       case 13: /* kbhit() */
	 Arg->I=Z_kbhit();
	 break;
       }
   }
   /* Cuando se sale del bucle el proceso se termina */
   Z_printf("     Gestor de Teclado y Video finalizado.\n");
   // El proceso muere
   ZEUS_terminar();
 }


