#include <stdio.h>

#include "define.h"

/*Rutina de obtencion de indice en un fichero .OBJ abierta de forma binaria,
fp:      el manejador del fichero para leer.
index:   puntero donde se devolvera el valor del indice.
retorna: 1 si el indice es de un byte y dos si un entero de 16 bits, o 2 bytes
	 tal y como se describe en la documentacion de los ficheros .OBJ*/


unsigned char indice(FILE *fp,unsigned short *index)
{

/*Antes se pondria sizeof(unsigned) o sizeof(byte), pero seria engaar,
  ya que en verdad es un o dos bytes, el tamao no dependeria de la maquina,
  pudiendo variar bastante, en un 386, dependeria si estamos en modo
  normal o en protegido, siendo la informacion falsa y erronea, haciendolo
  fallar, el modo protegido cambia el tamanio de algunos registros, pero no
  del indice de busqueda en tablas.*/


 unsigned char i1,aux,aux2;

 i1 = fgetc(fp);
 if (i1 & BIT7)
  {
   aux = (i1 & ~BIT7);
   aux2 = fgetc(fp);
   *index = (aux << 8) + aux2;
   return(2);
  }
 else
  {
   *index = i1;
   return(1);
  }
}
