#include <malloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "define.h"
#include "ledata.h"
#include "index.h"

/*Inserta un elemento nuevo en la lista, teniendo la parte de enlace
  inicializada a NULL*/
void insertaLe(ledata   **lista,unsigned short desp,unsigned short index,
               unsigned short tamano,unsigned char   *codigo)
{
  ledata   *nuevo,  *aux=*lista;

  if ((nuevo=(ledata    *) malloc(sizeof(ledata )))==NULL)
      {
	printf("No hay memoria suficiente");
	exit(0);
      }
  nuevo->desp=desp;
  nuevo->index=index;
  nuevo->Codigo.tamano=tamano;
  nuevo->Codigo.code=codigo;
  nuevo->Fixupp.th=NULL;
  nuevo->Fixupp.fp=NULL;
  nuevo->sig=aux;
  *lista=nuevo;
}

/*libera la lista y sus subcomponentes*/
void liberaLe(ledata   *lista)
{
  if (lista!=NULL){
  if (lista->sig!=NULL) liberaLe(lista->sig);
  liberaFx(lista->Fixupp.fp);
  liberaFt(lista->Fixupp.th);
   free(lista->Codigo.code);
   free(lista);}
}

/*inserta un registro ficupp en la lista*/
void insertaFx(ledata   **lista,fixupp   *reg)
{
ledata   *aux=*lista;

 reg->sig=aux->Fixupp.fp;
 aux->Fixupp.fp=reg;
}
/*libera la parte de los subregistros fixupp*/
void liberaFx(fixupp   *lista)
{
  if (lista!=NULL){
  if (lista->sig!=NULL) liberaFx(lista->sig);
   free(lista);}
}

/*inserta un registro Thread en la lista*/
void insertaFt(ledata   **lista,thread   *reg)
{
ledata   *aux=*lista;

 reg->sig=aux->Fixupp.th;
 aux->Fixupp.th=reg;
}

/*libera la parte de los subregistros thread*/
void liberaFt(thread   *lista)
{
  if (lista!=NULL){
  if (lista->sig!=NULL) liberaFt(lista->sig);
   free(lista);}
}

/*Procedimiento LeData*/
void Ledata(ledata   **Lista,FILE *fp,unsigned short tamanio)
/*El registro Ledata guarda informacion sobre codigo binario del programa,
  clasificandose segun el segmento que la contiene, pudiendo contener desde
  datos hasta el propio codigo del programa.
  Junto con el registro de enlace, son los registros mas importantes que
  se deben tener en cuenta en los ficheros OBJ.
  */
{
unsigned short i;
unsigned short index;
unsigned short segment;
unsigned char   *cadena;

   tamanio-=indice(fp,&index);
   char alto,bajo;
   bajo=fgetc(fp);
   alto=fgetc(fp);
   segment=bajo+(alto<<8);
   tamanio-=3;
   cadena=(unsigned char   *) malloc(tamanio);
   if (cadena==NULL){printf("Falta memoria"); exit(0);}
   for(i=0;i<tamanio;i++) cadena[i]=fgetc(fp);
   insertaLe(Lista,segment,index,tamanio,cadena);
   fgetc(fp);
}


/*Registro Fixupp*/
void Fixupp(ledata   **Lista,FILE *fp,unsigned short tamanio)
/*El registro de enlace o Fixupp, es el otro registro mas importante a
  tener en cuenta a la hora de realizar el enlace.
  Este registro guarda la informacion de que, como y donde se deben hacer
  las resoluciones de direcciones en el codigo binario. Esto es, si
  realizamos una llamada, en el codigo binario inicial no se obtendria
  su direccion, sino ceros. con el registro de enlace, los indices,
  los segmentos... etc, se han de resolver estas direcciones y sustituir
  lo que se nos indique en donde se nos diga.
  Un registro Ledata, puede o no tener asociado este registro,
  independientemente de si es dato o codigo.
  Si lo tiene asociado, este registro, se encontrara despues del registro
  Ledata, asociandose al ultimo aparecido.
  No suele darse el caso de que para un mismo Ledata haya varios registros
  fixupp, pero no se describe lo contrario en la documentacion.
  La informacion se detalla en los registro donde nosotros almacenamos
  dicha informacion, con el fin de verse mas claro*/
{
unsigned char i;
unsigned short index=0;
fixupp   *fix;
thread   *the;

   tamanio--;
   while(tamanio>0)
   {
     i=fgetc(fp);
     tamanio--;
     /*Si el bit7 es 0 tenemos un Thread subrecord, algo de lo que no
       hay mucha informacion, pero que tampoco parece darse mucho.
       Si es 1, tendremos un fixupp subrecord, mas comun y con mas
       informacion, de todas formas, tampoco esta muy documentado*/
     if (i&BIT7==0)
       {
	 index=0;
	 /*Thread subrecord*/
         unsigned char tres;
         unsigned short d,numero;

         the=( thread   *) malloc(sizeof(thread));
	 tres=(i&BIT5)+(i&BIT4)+(i&BIT3)>>3;/*campo thread*/
	 d=i&BIT6;/*bit d*/
	 if (d==0)
	    {
	     /*Target method*/
	     if (tres<3)
	       {
		 tamanio-=indice(fp,&index);
	       }
	    } /*frame method*/
	 else if (tres<3)
	       {
		 tamanio-=indice(fp,&index);
	       }
	 /*numero de target, algo que no se dice muy bien para que sirve*/
	 numero=(i&BIT2)+(i&BIT1)>>1;
	 the->numero=numero;
	 the->indice=index;
	 the->d=d;
	 the->metodo=tres;

	 insertaFt(Lista,the);
       }
	 /*fin de thread subrecord*/

     else /*Fixupp subrecord*/
       {
	/*Fixupp subrecord esta compueto por varios registros
	  El primero comun a todos.
	  El registro Fixdata, que no es opcional
	  Los indices condicionados a fixdata*/
         unsigned short m,p;
         unsigned char locat;
         unsigned short desp;

       index=0;
       fix=(fixupp   *) malloc(sizeof(fixupp));
       m=i&BIT6;
       locat=(i&BIT5)+(i&BIT4)+(i&BIT3)+(i&BIT2)>>2;
       desp=(i&BIT1)+(i&BIT0)+fgetc(fp);
       fix->locat.m=m;
       fix->locat.locat=locat;
       fix->locat.desp=desp;

       /* Fixdata*/
       i=fgetc(fp);
       tamanio-=2;
       unsigned char framen,f,t;
       unsigned char targt;

       framen=(i&BIT6)+(i&BIT5)+(i&BIT4)>>4;
       /*bit F*/
       f=(i&BIT7);
       /*bit T*/
       t=(i&BIT3);
       p=(i&BIT2);
       if (t==0)
	 {
	   targt=(i&BIT2)+(i&BIT1)+(i&BIT0);
	 }
       else
	 {
	   targt=(i&BIT1)+(i&BIT0);
	 }

       fix->fix.f=f;
       fix->fix.t=t;
       fix->fix.frame=framen;
       fix->fix.target=targt;
       fix->fix.p=p;

	/*indices si hay*/
       if ((framen<3))
	 {
	  tamanio-=indice(fp,&index);
	 }
       fix->Findex=index;
       index=0;
	if ( ((i&BIT3)==0) && ((targt==0)||(targt==4)||(targt==1)||(targt==5)||
	   (targt==2)||(targt==6)))
	   {
	    tamanio-=indice(fp,&index);
	   }
       fix->Tindex=index;
       fix->Tdesp=0;
       if ((i&BIT2)==0)
	 {
          char alto,bajo;
          bajo=fgetc(fp);
          alto=fgetc(fp);
          fix->Tdesp=bajo+(alto<<8);
	  tamanio-=2;
	 }

       insertaFx(Lista,fix);
       }
   }
   fgetc(fp); /*sumatorio ignorado*/
}
