#define LEDATA   0x0A0/*Bloque de informacion*/
#define PLEDATA  0x0A1/*Bloque de informacion para modo protegido*/

#define FIXUPP   0x9C /*Registro de enlace*/
#define PFIXUPP  0x9D /*REgistro de enlace para modo protegido*/



typedef struct location
   {
    unsigned short m:1;/*indica si es relativo a si mismo o a un segmento*/
    unsigned short locat:4;/*indica que es lo que hay que enlazar*/
    unsigned short desp:10;/*su desplazamiento dentro del codigo*/
   } location;

typedef struct fixdata
   {
    unsigned short f:1;/*indica si frame es un metodo o no, de todas formas no
		   parece tener mucha utiliada*/
    unsigned short frame:3;/*dependiendo de f, un metodo o un Framenumbre,
		       normalmente es un metodo*/
    unsigned short t:1;/*determina si p y target es un metodo o no*/
    unsigned short p:1;/*si p=1, habra campo desplazamiento*/
    unsigned short target:2;/*o un metodo o un indice a thread*/
   } fixdata;

typedef struct fixupp
   {
    location locat;
    fixdata  fix;
    unsigned short Findex,Tindex,Tdesp;/*indices y desplazamiento*/
    struct fixupp   *sig;
   } fixupp;

typedef struct thread
   {
    unsigned short d:1;/*indica el tipo de metodo, si 0 target, si es 1 frame*/
    unsigned short metodo:3;/*metodo correspondiente*/
    unsigned short numero:2;/*numero de thread*/
    unsigned short indice;/*indice condicionado al metodo*/
    struct thread   *sig;
   } thread;


typedef struct enlace
   {
     thread   *th;/*la parte correspondiente a thread*/
     fixupp   *fp;/*la parte correspondiente a fixupp*/
   } enlace;

/*Estructura que guarda la informacion que necesitamos*/
typedef struct ledata
   {
     unsigned short desp;/*desplazamiento en el segmento*/
     unsigned short index;/*indice del segmento*/
     struct codigo
	{
          unsigned short tamano:10; /*El maximo bloque de codigo permitido es de
				1024 bytes de vez, por motivos de enlace*/
          unsigned char   *code;/*codigo*/
	} Codigo;
     enlace Fixupp;/*registro de enlace*/
     struct ledata   *sig;
   } ledata;


/*inserta un elemento en la lista*/
void insertaLe(ledata **lista,unsigned short desp,unsigned short index,
               unsigned short tamano,unsigned char *codigo);
/*libera la lista*/
void liberaLe(ledata *lista);


void insertaFx(ledata   **lista,fixupp   *reg);
void liberaFx(fixupp   *lista);
void insertaFt(ledata   **lista,thread   *reg);
void liberaFt(thread   *lista);

/*obtiene la informacion del fichero correspondiente unicamente del registro
  Ledata*/
void Ledata(ledata   **,FILE *,unsigned short);

void Fixupp(ledata   **,FILE *,unsigned short);