#define SEGDEF   0x98 /*Definicion de segmento*/
#define PSEGDEF  0x99 /*Definicion de segmento para modo protegido*/

typedef struct segmento
   {
     unsigned short napa; /*indice de orden de aparicion*/
     unsigned short alinea:3; /*Campo de 3 bits que representa la alineacion del
			   segmento*/
     unsigned short combina:3;/*Campo de 3 bits que indica como se pueden enlazar
			  con otros segmentos*/
     unsigned short big:1;    /*Campo de 1 bit que indica un tamao relativo del
			   del segmento*/
     unsigned short p:1;      /*Campo de 1 bit que indica si es modo protegido o
			  no*/
     unsigned short frame,desp,longitud,Nindex,Clasindex,Overindex;
       /*frame es un indice que indica un numero de frame.
	 desp inidica el desplazamiento dentro del segmento para su
	   comienzo, tanto frame y desp van unidos a la condicion de que
	   alinea sea 0, indicando un segmento absoluto.
	 Longitud es el campo que indica la longitud del segmento.
	 Nindex es el indice del nombre que asociamos al segmento .
	 Clasindex es el indice del nombre que asociamos a la clase del
	   segmento.
	 Overindex es el indice del nombre que asociamos a la clase de
	   overlay que tiene ese segmento.
       */
     struct segmento  *sig;
   } segmento;


/*inserta un elementoen la lista*/
void insertaS(segmento  **lista,
              unsigned char alinea,
              unsigned char combina,
              unsigned char big,
              unsigned char p,
              unsigned short frame,
              unsigned short desp,
              unsigned short longitud,
              unsigned short Nindex,
              unsigned short Clasindex,
              unsigned short Overindex);

/*libera la lista*/
void liberaS(segmento  *lista);

/*obtiene la informacion del fichero para, haceiendo una llamada a insertaS
  lo inserte en la lista*/
void Segdef(segmento  **,FILE *);