// ZEUS! : <SISTEMA.C>

#include <dos.h>
#include "defines.h"
#include "tipos.h"

void establece_int( unsigned int N_Interrupcion,
		    void interrupt ( far *GestorINT )(...) );
void establece_int( unsigned int N_Interrupcion,
		    void interrupt ( far *GestorINT )(...) ) {
 setvect( N_Interrupcion, GestorINT );
}

void far *recoge_int( unsigned int N );
void far *recoge_int( unsigned int N ) {
 return getvect( N );
}

unsigned FP_SEGa( void far * fp );
unsigned FP_SEGa( void far * fp ) {
 unsigned long H, L, Real;

 H = ( ( unsigned long ) fp ) >> 16;
 L = ( ( unsigned long ) fp ) & 0xFFFF;

 Real = ( H << 4 ) + L;

 if( Real < 0xFFFF ) {
  H = 0;
  L = Real;
 } else {
  H = (Real>>4) - 0xFFF;
  L = 0xFFF0 + ( Real & 0xF );
 }

 return H;
}

unsigned FP_OFFa( void far * fp );
unsigned FP_OFFa( void far * fp ) {
 unsigned long H, L, Real;

 H = ( ( unsigned long ) fp ) >> 16;
 L = ( ( unsigned long ) fp ) & 0xFFFF;

 Real = ( H << 4 ) + L;

 if( Real < 0xFFFF ) {
  H = 0;
  L = Real;
 } else {
  H = (Real>>4) - 0xFFF;
  L = 0xFFF0 + ( Real & 0xF );
 }

 return L;
}

unsigned FP_SEGb( void far * fp );
unsigned FP_SEGb( void far * fp ) {
 unsigned long H, L, Real;

 H = ( ( unsigned long ) fp ) >> 16;
 L = ( ( unsigned long ) fp ) & 0xFFFF;

 Real = ( H << 4 ) + L;

 return Real>>4;
}

unsigned FP_OFFb( void far * fp );
unsigned FP_OFFb( void far * fp ) {
 unsigned long H, L, Real;

 H = ( ( unsigned long ) fp ) >> 16;
 L = ( ( unsigned long ) fp ) & 0xFFFF;

 Real = ( H << 4 ) + L;

 return Real & 0xF;
}
