//
// Archivo    : CTRDISCO.H
// Descripcin: Archivo de cabecera de todas las rutinas de acceso a disco
//                como de sus estrupturas de datos.
// Resp. Mant.: Javier Cuevas ( jcd@arrakis.es )
// Ult. Modif.: 27/07/97
//

/* defines utilidados */
#define WORD   unsigned short
#define BYTE   unsigned char
#define DWORD  unsigned long
#define TRUE  1
#define FALSE 0
#define VERSION "Zeus shell v1.0. Por J.Cuevas Software. Junio de 1997 (c)."
 /* definicion de estrupturas de datos */

 /* Entrada de particion */
 typedef struct {
    unsigned char ParticionActiva;/* 0 -> P. inactiva; 0x80 ->P. Arranque */
    unsigned char CabezaInicio;   /* Cabeza de inicio Particion */
    unsigned char SectorInicio;   /* bits 0..5 (sector inicio);
				     bits 6,7 Parte alta del numero de cilindro*/
    unsigned char CilindroInicio; /* Parte baja del numero de cilindro*/
    unsigned char TipoParticion;  /* Tipo de particion  */
    unsigned char CabezaFin;      /* Cabeza de fin Particion */
    unsigned char SectorFin;      /* bits 0..5 (sector fin);
				     bits 6,7 Parte alta del numero de cilindro*/
    unsigned char CilindroFin;    /* Parte baja del numero de cilindro */
    DWORD SectoresRelativosInicio;/* Numeros de sectores desde el inicio
				     del disco hasta el comienzo de la particion */
    DWORD LongParticionEnSectores;/* Tamao de la particion en Sectores */
 }TpEntradaParticion;

 /* Sector de arranque */

 typedef struct {
      char basura[3];          /* Informacion basura */
      BYTE IdDelSistema[8];       /* Identificacion del sistema */
      WORD BytesPorSector;     /* Bytes por sector */
      BYTE SectoresPorCluster; /* SectoresPorCluster */
      WORD SectoresReservados; /* Sectores reservados al inicio */
      BYTE CopiasFAT;          /* Numero de copias de la FAT   */
      WORD EntradasRaiz;       /* Numero de entradas en el dir. Raiz */
      WORD TotalSectores1;     /* Total sectores en disco. Si >32Mb => 0 */
      BYTE TipoDisco;          /* Tipo de disco */
      WORD SectoresPorFAT;     /* Numero de sectores ocupado por cada FAT */
      WORD SectoresPorPista;   /* Numero de sectores por pista */
      WORD Cabezas;            /* Numero de cabezas */
      DWORD SectAsumarAlDOS;   /* Numero de sectores reservados. A sumar a
				  los sectores del DOS. 0 en unidades de
				  disquete */
      DWORD TotalSectores2;    /* Total sectores en disco para >32Mb */
      BYTE NumUnidadFisica;    /* Numero de unidad fisica */
      BYTE Reservado;          /* Byte reservado */
      BYTE Validacion;         /* Byte de validacion. Vale 0x29 si los bytes
				   entre el 26 y el 61 son validos */
      DWORD NumeroSerie;       /* Numero de serie */
      BYTE TituloDisco[11];    /* Titulo del disco */
      BYTE SistemaFicheros[8];    /* Tipo de sistema de ficheros "FAT12  " o
							      "FAT16  " */
   } TpSectorArranque;

typedef struct _TpRegistroCache {
    WORD ID;                 /* Identificador de entrada en cache       */
    WORD NumCluster;         /* Numero de Cluster                       */
    WORD Pos;                /* Registro de Reubicacion                 */
    DWORD NumAccesos;        /* Numero de Acceso al Cluster             */
    BYTE Modificado;         /* Controla si se ha escrito en el Cluster */
    void far *Buffer;            /* Puntero a la Copia del Cluster en Mem */
    struct _TpRegistroCache far *Sig;  /* Puntero al Siguiente Cluster En Cache */
    struct _TpRegistroCache far *Ant;  /* Puntero al Anterior  Cluster En Cache */
  } TpRegistroCache;

 /*  Entrada en directorio */

 typedef struct {
   char     Nombre[8];      // Nombre del fichero.
   char     Extension[3];   // Extensin del fichero.
   BYTE     Atributos;      // Atributos del fichero.
   char     Reservado[10];  // 10 Bytes reservados.
   WORD     Hora;           // La hora de ltima modificacon del fichero.
   WORD     Fecha;          // La fecha de ltima modificacon del fichero.
   WORD     EntradaFAT;     // Nmero del 1 Cluster del fichero.
   DWORD    LongEnBytes;    // Tamao del fichero en Bytes.
   } TpEntradaDir;


  typedef struct {
    BYTE Unidad;                     /* Unidad BIOS */
    TpSectorArranque SectorArranque; /* Copia del Sector de Arranque */
    DWORD LongFAT;                    /* Longitud de la FAT */
    BYTE TipoFAT;                    /* TipoFat : FAT12 ; FAT16 */
    BYTE ModificadoFAT;              /* True ->Si se ha escrito en alguna FAT */
    char far *FAT1;                      /* Copia de la FAT1 */
    char far *FAT2;                      /* Copia de la FAT2 */
    BYTE ModificadoRaiz;             /* True ->Si se hubira modificado alguna */
				     /*         entrada en el Raiz */
    TpEntradaDir far *Raiz;              /* Copia del Dir Raiz */
    /* Datos sobre la unidad */
    WORD  NumCilindros;
    DWORD TotalClusters;
    DWORD TotalSectoresDeDatos;
    DWORD TotalEnBytes;
    /* Coordenadas BIOS  de inicio de los Datos */
    WORD Cilindro;
    BYTE Cabeza,Sector;
    TpRegistroCache far *Cache;          /* Puntero Base de memoria Cache */
    } TpInformacionUnidad;

/* definimos el Handle del Sistema */
typedef struct {
  TpEntradaDir             EntradaDir;         // Copia de la entrada de directorio del fichero.
  DWORD                    NumClusterEntrDir;  // Nmero del cluster donde se encuentra la entrada de directorio del fichero
  WORD                     NumEntrDir;         // Nmero de entrada de directorio dentro del cluster.
  TpInformacionUnidad far  *Unidad;            // Puntero a la unidad donde esta el fichero.
  DWORD                    BytesLeidos;        // Posicin respecto al inicio del fichero de la cabeza lectora.
  DWORD                    BytesLeidosEnClusterActual;  // Posicion dentro del cluster actual de la cabeza lectora.
  WORD                     ClusterActual;      // Cluster de donde esta leyendo la cabeza lectora.
  BYTE                     ModoDeApertura;     // Mode de apertura del fichero. De momento no se usa.
  BYTE                     Eof;                // Marca de fin de fichero. TRUE si se ha llegado y FALSE si no se ha llegado.
  } TpHandle;


/********** Implementacion del Nucleo del Sistema de Ficheros *********/

typedef struct _SistemaDeFicheros {
    char far *Ruta;                    /* Ruta Base del sistema de ficheros */
    TpInformacionUnidad Unidad;    /* Unidad Asociada                   */
    WORD HandleInicial;            /* Handle Inicial                    */
    struct _SistemaDeFicheros far *Sig;/* Puntero a la siguiente Unidad     */
   } TpSistemaDeFicheros;

typedef struct _FicherosAbiertos {
   WORD ID;                       /* Indentificador del fichero */
   char far *Ruta;                // Ruta del fichero
   TpHandle far *Handle;              /* Informacion acerca del fichero */
   struct _FicherosAbiertos far *Sig; /* Puntero al siguinte fichero */
  } TpFicherosAbiertos;

/* Estruptura de almacenamiento de errores en el shell */
typedef struct {
  WORD TipoError;              // Cdigo numrico del error.
  char far *DescripcionError;  // Descripcin del error.
 }TpError;

/* Estruptura de almacenamiento de informacin de unidades montadas en el sistema */
typedef struct {
  char Ruta[128];       // Ruta sobre la que va montada la unidad.
  WORD UnidadBIOS;      // Unidad Bios de la unidad montada.
  DWORD BytesLibres;    // Bytes libres de la unidad.  = NumClustersLibres*TamoDelClusterEnBytes.
  DWORD BytesOcupados;  // Bytes ocupados de la unidad = NumClustersUsados*TamoDelClusterEnBytes.
  DWORD BytesTotales;   // Bytes Totales = NumClustersTotales*TamoDelClusterEnBytes.
 } TpInfoUnidadesMontadas;

/****** Estruptura genrica utilizada en las llamadas al sistema ******/

typedef struct {
 int S;		// Servicio a realizar 1..21 y cdigo de respuesta.
 int I;			// Argumentos que sea int
 DWORD D;		// Argumentos que sea DWORD
 void far *A;		// Argumentos que sean int far *  char far *
 void far *B;		// Doble argumento char far *
 void far *R;		// TZIP del proceso que solicita servicio.
 char C;                // Argunentos que sea char
 char C2;               // Mas argunentos que sean char
 char C3;               // Mas argunentos que sean char
 void far *E;		// TZIP del proceso que solicita servicio.
} tpZSFA;


/********************************************************************/
/********************************************************************/
/*****                                                          *****/
/*****     Las funciones que componen el sistema de ficheros    *****/
/*****  se pueden dividir en tres fases de abstracin.          *****/
/*****     La primera trata el disco a nivel fisico slo        *****/
/*****  entiende de sectores, cilindros y cabezas. En esta fase *****/
/*****  se crean rutinas que faciliten el trabajo en este nivel *****/
/*****     La segunda fase interpreta ya la informacin         *****/
/*****  contenida en el disco y la interpreta, dando soporte a  *****/
/*****  unidades, ficheros y directorios. Pero aun no se tiene  *****/
/*****  un interface cmodo y uniforme con el que trabajar con  *****/
/*****  el disco.                                               *****/
/*****     En la tercera fase, ya se han creado todas las       *****/
/*****  rutinas necesarias para trabajar de una forma cmoda e  *****/
/*****  uniforme. Existe una rutina para cada cosa y trabajan   *****/
/*****  cada una de una forma parecida, manteniendo un interface*****/
/*****  de entrada y de salida homogeneo                        *****/
/*****                                                          *****/
/*****     En el cdigo fuente crtdisco.h Estn todas las       *****/
/*****  rutinas mezcladas. No obstante en este archivo de       *****/
/*****  cabecera se ha querido introducir este comentario para  *****/
/*****  facilitar la lectura de estas rutinas. En este archivo  *****/
/*****  las estrupturas de datos asi como el orden en que       *****/
/*****  aparecen las rutinas poseen un orden que creemos        *****/
/*****  facilitar su comprensin.                              *****/
/*****                                                          *****/
/*****              Buena Suerte y buena caza.                  *****/
/*****                                                          *****/
/*****                          web                             *****/
/*****                                                          *****/
/********************************************************************/
/********************************************************************/


/****  Primera fase de abstracin ****************/

int LeeSectorBIOS(BYTE Unidad,WORD Cilindro,BYTE Cabeza,
		  BYTE Sector,BYTE NumSectores,BYTE far *Buffer);

int EscribeSectorBIOS(BYTE Unidad,WORD Cilindro,BYTE Cabeza,
		      BYTE Sector,BYTE NumSectores,BYTE far *Buffer);

int LeeSector(BYTE Unidad,WORD Cilindro,BYTE Cabeza,
	      BYTE Sector,BYTE NumSectores,BYTE far *Buffer,
	      TpSectorArranque far *Info);


int EscribeSector(BYTE Unidad,WORD Cilindro,BYTE Cabeza,
		  BYTE Sector,BYTE NumSectores,BYTE far *Buffer,
		  TpSectorArranque far *Info);


int CargaSectorArranque(BYTE Unidad,TpSectorArranque far *SectArranque);
int CargaTablaDeParticion(int Unidad,TpEntradaParticion far *pTablaParticion);
void CopiaBuffer(char far *Origen,char far *Destino,int NumBytes);
void CalculaPosicion(BYTE far *Cabeza,BYTE far *Sector,WORD far *Cilindro,
		     WORD NumSectores,TpSectorArranque far *Info);
int CuentaSectores(BYTE Cabeza1,BYTE Sector1,WORD Cilindro1,
		   BYTE Cabeza2,BYTE Sector2,WORD Cilindro2,
		   WORD far *NumSectores,TpSectorArranque far *Info);

int IniciaUnidad(int UnidadBIOS,TpInformacionUnidad far *Unidad);

/********* Segunda fase de abstraccin ***************/
int LeeCluster(TpInformacionUnidad far *Unidad,int Cluster,char far *Buffer);
int EscribeCluster(TpInformacionUnidad far *Unidad,int Cluster,char far *Buffer,int ForzarADisco);
int CalculaSiguienteCluster(WORD far *Cluster,TpInformacionUnidad far *Unidad);
int LeeClusterEnFAT(WORD Cluster,WORD *Valor,TpInformacionUnidad far *Unidad);
int EscribeClusterEnFAT(WORD Cluster,WORD Valor,TpInformacionUnidad far *Unidad);
int ClusterLibre(TpInformacionUnidad far *Unidad);

int TipoFichero( char far *Ruta,TpInformacionUnidad far *Unidad,
		 TpEntradaDir far *EntradaDir, DWORD far *NumClusterEntrDir,
		 DWORD far *NumEntrDir);

int VaciaCache(TpInformacionUnidad far *Unidad);
void BytesLibres(TpInformacionUnidad far *Unidad,
		 DWORD *BytesLibres,
		 DWORD *BytesOcupados,
		 DWORD *BytesTotales);

TpFicherosAbiertos far *DamePunteroAFichero(int Manejador);

int IsClusterEnCache(WORD NumCluster,TpRegistroCache far **Cache,TpRegistroCache far *Lista);
int PonPrimero(TpRegistroCache *Cache,TpRegistroCache far **Lista);
int NuevaEntradaEnCache(TpRegistroCache **Cache,TpInformacionUnidad far *Unidad);

int CreaFichero(char far *Nombre,char far *Ext,TpEntradaDir far *EntradaDir,
		WORD Cluster, int NumEntrDir,TpInformacionUnidad far *Unidad);
int TipoFichero( char far *Ruta,TpInformacionUnidad far *Unidad,
		 TpEntradaDir far *EntradaDir,
		 DWORD far *NumClusterEntrDir,
		 DWORD far *NumEntrDir);
int DameNombreFichero(char far *NombreFichero,TpEntradaDir far *pEntradaDir);

/***** Tercera fase de abstracin */
int InicializaSistemaFicheros(int UnidadAMontarEnRaiz);
int CierraSistemaFicheros(void);
int MontarUnidad(int UnidadAMontar, char far *Ruta);
int DesmontarUnidad(char far *Ruta);
int AbrirFichero(int far *Manejador,char far *Ruta);
int CerrarFichero(int Manejador);
int LeerFichero(int Manejador,DWORD Bytes,char far *Buffer);
int EscribirFichero(int Manejador,DWORD Bytes,char far *Buffer);
int Situar(int Manejador,DWORD Bytes);
DWORD LongFichero(int Manejador);
int Eof(int Manejador);
int CrearFichero(char far *Ruta);
int BorrarFichero(char far *Ruta);
int CrearDirectorio(char far *Ruta);
int BorrarDirectorio(char far *Ruta);
int NumEntradasEnDirectorio(char far *Ruta,WORD far *NumEntradas);
int ListaArchivos(char far *Ruta,TpEntradaDir far *Buffer);
int DameTipoFichero(char far *Ruta);
int NumUnidadesMontadas(void);
void DameUnidadesMontadas(TpInfoUnidadesMontadas far *UnidadesMontadas);

/**************** Fin CTRDISCO.H ******************************/

