//
// Archivo    : ZDEMO.C
// Descripcin: Archivo de cdigo fuente que contiene la demo de ZEUS.
// Resp. Mant.: Jose Juan Barco
// Ult. Modif.: 23/07/97
//


// Programa con una demos de Zeus.


#include <conio.h>	// E/S consola.
#include <stdlib.h>	// Nmero aleatorios.
#include <stdio.h>
#include <string.h>	// Cadenas.
#include "defines.h"	// Definiciones de 	ZEUS!
#include "tipos.h"	// Tipos de 		ZEUS!
#include "ZEUS.H"	// Servicios de 	ZEUS!
#include "ZGM\zmem.h"

	typedef struct {
	    int X1, Y1,
		X2, Y2,
		X3, Y3;
	    char Color;
	} tpPoligono;		// Tipo que define un polgono de 3 lados.
	#define PASA_Y		320
	void flat( tpPoligono *P, char far *Pantalla );
	void estableceRGB( char NC, char R, char G, char B );
	void escribe_cadena( int X, int Y, char *C, char far *V );

#define T_PILAS		50000

extern TZIP ZGM; // Del proceso gestor de memoria.

TZIP VuelcaPantalla;	// Proceso que vuelca la ventana grfica.
TZIP          Fondo;	// Proceso que controla los procesos.
TZIP        Frontal;	// Proceso que pone el frontal a la ventana.

void PVuelcaPantalla( void );
void          PFondo( void );
void        PFrontal( void );

void _ZeusDemo(); void ZeusDemo() { _ZeusDemo(); }
void _ZeusDemo() {
  register unsigned C;
  register unsigned far *Video, far *_Pantalla;
  static char far *VIDEO = ( char far * ) 0xA0000000L;
  char Terminar = 0;
  char far *Pantalla; // Buffer para guardar la imgen a volcar.
  unsigned far *Indice; // Para recorrerlo a 16bits en lugar de 8bits.
  #define ANCHO 150
  #define ALTO  60
  static tpPoligono Poligono[12] =
   {
    {  90,  70, 120,  90, 115,  70, 15 },
    { 120,  90,  90, 120, 100,  95, 15 },
    {  90, 120, 120, 130, 110, 115, 15 },
    { 140,  80, 160,  80, 150,  75, 15 },
    { 140,  90, 160, 100, 150,  90, 15 },
    { 130, 120, 160, 130, 147, 115, 15 },
    { 140,  80, 130, 120, 127,  95, 15 },
    { 180,  80, 190, 130, 176, 105, 15 },
    { 190, 130, 210,  90, 211, 111, 15 },
    { 240,  80, 220,  90, 227,  75, 15 },
    { 220,  90, 240, 110, 235,  92, 15 },
    { 240, 110, 220, 130, 227, 113, 15 },
   };
  #define TURNOS_ESPERA_CREDITO		250
  #define TEXTOS	10
  #define VIBRACION	3
  #define COLOR_T  	255
  static char *Texto[ TEXTOS ] =
   {
    "E.U.P.L.A. 1996/97",
    "Sistemas Operativos II",
    "!!!!!! ZEUS !!!!!!",
    "Grupo ZEUS...",
    "...Barco Montero, Jose Juan...",
    "...Cuevas, Javier...",
    "...Garcia Mendoza, Oscar...",
    "...Vela Perez, Jose Luis...",
    "...Y...",
    "...esto es solo el principio..."
   };
  static int Color = 0, Incremento = 1, X = 0, Y = 0, IX = 1, IY = 1;
  static unsigned char CreditoActual = 0, EsperaCredito = 0;
  register int Toca;
  static tpPoligono Poli;

  asm { mov ax, 0x13; int 0x10 }; // Establecemos el modo 320x200x256


  Pantalla = ( char far * ) farmalloc( 64000 ); // Pedimos memoria.
  // Si no hay memoria, miramos a ver que pasa :
   if( Pantalla == 0 ) {
    asm { mov ax, 7; int 0x10 };
    printf("  ZEUS-DEMO ! Error : no hay memoria suficiente.\n\n");
    Terminar = 1;
   }

   // Degradamos la paleta :
   for( Color = 64; Color < 128; Color++ )
    estableceRGB( Color - 63, Color, Color >> 2, 0 );
   estableceRGB( COLOR_T, 63, 63, 63 ); // Color TEXTO.

  // Preparamos polgonos :
   for( Toca = 0; Toca < 12; Toca++ ) {
    Poligono[Toca].X1 -= 90; Poligono[Toca].X2 -= 90; Poligono[Toca].X3 -= 90;
    Poligono[Toca].Y1 -= 70; Poligono[Toca].Y2 -= 70; Poligono[Toca].Y3 -= 70;
   }
   Color = 1;

  for(;!Terminar;) {
   // Si pulsan un a tecla hay que salir :
    if( kbhit()) {
     Terminar = 1;
     getch();
    }

   // Limpiamos la pantalla :
    for( Video = ( unsigned far * ) Pantalla, C = 0; C < 32000; C++ )
     *Video++ = 0;

    for( Toca = 0; Toca < 12; Toca++ )
     Poligono[ Toca ].Color = Color;
    Color += Incremento;
    if( Color == 1 || Color == 63 )
      Incremento *= -1;
    if( X + ANCHO >= 310 || X < 0 ) IX *= -1;
    if( Y + ALTO  >= 189 || Y < 0 ) IY *= -1;
    X += IX; Y += IY;

   // Dibujamos en ella lo que nos parezca :
    for( Toca = 0; Toca < 12; Toca++ ) {
     Poli = Poligono[ Toca ];
     Poli.X1 += X; Poli.X2 += X; Poli.X3 += X;
     Poli.Y1 += Y; Poli.Y2 += Y; Poli.Y3 += Y;
     flat( &Poli, Pantalla );
    }

   // Mostramos los crditos :
    escribe_cadena( 160 - ( strlen( Texto[ CreditoActual ] ) << 2 ) + random(VIBRACION),
		    96 + random(VIBRACION),
		    Texto[ CreditoActual ], Pantalla );
    if( ++EsperaCredito >= TURNOS_ESPERA_CREDITO ) {
     EsperaCredito = 0;
     if( ++CreditoActual >= TEXTOS )
      CreditoActual = 0;
    }
   // Volcamos la pantalla a la memoria de vdeo :
    _Pantalla = (unsigned far *)Pantalla;
    for( Video = ( unsigned far * ) VIDEO, C = 0; C < 32000; C++ )
     *Video++ = *_Pantalla++;

  }
  asm { mov ax, 0x7; int 0x10 }; // Establecemos el modo texto

  if( Pantalla != 0 )
   farfree( Pantalla );
 }


// Procesos grficos :

void flat( tpPoligono *P, char far *Pantalla ) {
 long int topx, botx, midx, t1x, t2x,
     topy, boty, midy, t1y, t2y;

 if( P->Y1 < P->Y2 )
  if( P->Y2 < P->Y3 ) {         // P1 es el menor, P3 es el mayor.
   topx = P->X3; topy = P->Y3;
   midx = P->X2; midy = P->Y2;
   botx = P->X1; boty = P->Y1;
  } else
   if( P->Y1 < P-> Y3 ) {       // P1 es el menor, P2 el mayor.
    topx = P->X2; topy = P->Y2;
    midx = P->X3; midy = P->Y3;
    botx = P->X1; boty = P->Y1;
   } else {                     // P2 es el mayor, P3 el menor.
    topx = P->X2; topy = P->Y2;
    midx = P->X1; midy = P->Y1;
    botx = P->X3; boty = P->Y3;
   }
 else
  if( P->Y1 < P->Y3 ) {         // P2 es el menor, P3 es el mayor.
   topx = P->X3; topy = P->Y3;
   midx = P->X1; midy = P->Y1;
   botx = P->X2; boty = P->Y2;
  } else 
   if( P->Y2 < P-> Y3 ) {       // P2 es el menor, P1 el mayor.
    topx = P->X1; topy = P->Y1;
    midx = P->X3; midy = P->Y3;
    botx = P->X2; boty = P->Y2;
   } else {                     // P1 es el mayor, P3 el menor.
    topx = P->X1; topy = P->Y1;
    midx = P->X2; midy = P->Y2;
    botx = P->X3; boty = P->Y3;
   }

 {
  long int c1;
  long unsigned i;
  char c = P->Color, far *d, far *d2;
  union {
   long int w;
   struct {
    int short l;
    int short h;
   } m;
  } xmb, xtb;
  long int dmb, dtb;

  dmb = 65536.0 * ( midx - botx + 1 ) / (double) ( midy - boty + 1 );
  dtb = 65536.0 * ( topx - botx + 1 ) / (double) ( topy - boty + 1 );

  xmb.w = botx<<16; xtb.w = botx<<16;

  c1 = boty;
  d2 = Pantalla + ( c1 << 8 ) + ( c1 << 6 ) ; 

  if( dmb > dtb ) 
   for( c1 = boty; c1 < midy; c1++ ) {
    d = d2 + xtb.m.h;
    for( i = xtb.m.h; i <= xmb.m.h; i++ ) *d++ = c;
    xmb.w += dmb; xtb.w += dtb; d2 += PASA_Y;
   }
  else
   for( c1 = boty; c1 < midy; c1++ ) {
    d = d2 + xmb.m.h;
    for( i = xmb.m.h; i <= xtb.m.h; i++ ) *d++ = c;
    xmb.w += dmb; xtb.w += dtb; d2 += PASA_Y;
   }

  dmb = 65536.0 * ( topx - midx + 1 ) / (double) ( topy - midy + 1 );

  xmb.w = midx<<16;

  c1 = midy;
  d2 = Pantalla + ( c1 << 8 ) + ( c1 << 6 );

  if( dmb < dtb )
   for(; c1 <= topy; c1++ ) {
    d = d2 + xtb.m.h;
    for( i = xtb.m.h; i <= xmb.m.h; i++ ) *d++ = c;
    xmb.w += dmb; xtb.w += dtb; d2 += PASA_Y;
   }
  else
   for(; c1 <= topy; c1++ ) {
    d = d2 + xmb.m.h;
    for( i = xmb.m.h; i <= xtb.m.h; i++ ) *d++ = c;
    xmb.w += dmb; xtb.w += dtb; d2 += PASA_Y;
   }
 }
}

void estableceRGB( char NC, char R, char G, char B ) {
 asm {
  mov al, NC
  mov dx, 0x3C8
  out dx, al
  mov al, R
  mov dx, 0x3C9
  out dx, al
  mov al, G
  out dx, al
  mov al, B
  out dx, al
 }
}

void escribe_cadena( int X, int Y, char *C, char far *V ) {
 static char far *ASCII = ( char far * ) 0xF000FA6EL;
 register unsigned Cy, Cx, Bit;
 while(*C) {
  char far *MAPA = ASCII + (( *C & 0x7F )<<3);

  X += 8;
  for( Cy = 0; Cy < 8; Cy++, MAPA++ )
   for( Cx = 0, Bit = 1; Cx < 8; Cx++, Bit <<= 1 )
    if( *MAPA & Bit )
     *( V + X - Cx + ((Y + Cy)<<8)+((Y + Cy)<<6)) = COLOR_T;
  C++;
 }
}
