//
// Archivo    : ZSF.C
// Descripcin: Archivo de cdigo fuente que contiene la implementacin del
//              inteface en ZEUS (paso de mensajes ) con el servidor de Ficheros.
// Resp. Mant.: Javier Cuevas ( jcd@arrakis.es )
// Ult. Modif.: 23/07/97
//

#include "defines.h"	// Definiciones de 	ZEUS!
#include "tipos.h"	// Tipos de 		ZEUS!
#include "ZEUS.H"	// Servicios de 	ZEUS!
#include "memoria.h"	// Gestor de memoria.
#include "ZSF\CTRDISCO.H"
#include "ZSF\ERROR.H"
#include "ZSF\ZSF.h"

extern TZIP ZSF;

//  Todas las rutinas aqui implementadas, son peticiones de servicio de disco
// efectuadas al servidor de ficheros. Como se puede ver, no son mas que
// una implementacin de paso de mensajes a un preoceso. El proceso ZSF.
//  Todas las rutinas son iguales, exceptuando el contenido del mensaje,
// donde se le pasa el servicio a realizar y la informcacin necesaria para
// efectuar ese servicio.
//  No se necesita comentar nada mas.

int ZSF_InicializaSistemaFicheros(int UnidadAMontarEnRaiz)
  {  tpZSFA Arg={ INICIALIZA_ZSF, UnidadAMontarEnRaiz, 0 , 0 , 0 , 0 };
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_CierraSistemaFicheros(void)
  {  tpZSFA Arg={ CIERRA_ZSF, 0, 0 , 0 , 0 , 0 };
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_MontarUnidad(int UnidadAMontar, char far *Ruta)
  {
     tpZSFA Arg={ MONTAR_UNIDAD, UnidadAMontar, 0 , Ruta , 0 , 0, 0 };
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_DesmontarUnidad(char far *Ruta)
  {
     tpZSFA Arg={ DESMONTAR_UNIDAD, 0, 0 , Ruta , 0 , 0 , 0 };
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_AbrirFichero(int far *Manejador,char far *Ruta)
  {
     tpZSFA Arg={ ABRIR_FICHERO, 0, 0 , Manejador ,Ruta , 0 , 0 };
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_CerrarFichero(int Manejador)
  {
     tpZSFA Arg={ CERRAR_FICHERO, Manejador, 0 , 0 , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_LeerFichero(int Manejador,DWORD Bytes,char far *Buffer)
  {
     tpZSFA Arg={ LEER_FICHERO, Manejador , Bytes , Buffer , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_EscribirFichero(int Manejador,DWORD Bytes,char far *Buffer)
  {
     tpZSFA Arg={ ESCRIBIR_FICHERO, Manejador, Bytes , Buffer , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_Situar(int Manejador,DWORD Bytes)
  {
     tpZSFA Arg={ SITUAR, Manejador, Bytes , 0 , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

DWORD ZSF_LongFichero(int Manejador)
  {
     tpZSFA Arg={ LONG_FICHERO, Manejador, 0 , 0 , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.D );
  }

int ZSF_Eof(int Manejador)
  {
     tpZSFA Arg={ FIN_FICHERO, Manejador, 0 , 0 , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_CrearFichero(char far *Ruta)
  {
     tpZSFA Arg={ CREAR_FICHERO, 0, 0 , Ruta , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_BorrarFichero(char far *Ruta)
  {
     tpZSFA Arg={ BORRAR_FICHERO, 0, 0 , Ruta , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_CrearDirectorio(char far *Ruta)
  {
     tpZSFA Arg={ CREAR_DIRECTORIO, 0, 0 , Ruta , 0 , 0 };
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_BorrarDirectorio(char far *Ruta)
  {
     tpZSFA Arg={ BORRAR_DIRECTORIO, 0, 0 , Ruta , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_NumEntradasEnDirectorio(char far *Ruta,WORD far *NumEntradas)
  {
     tpZSFA Arg={ NUM_ENTRADAS_EN_DIRECTORIO, 0, 0 , Ruta , NumEntradas , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_ListaArchivos(char far *Ruta,TpEntradaDir far *Buffer)
  {
     tpZSFA Arg={ LISTA_ARCHIVOS, 0, 0 , Ruta , Buffer , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_DameNombreFichero(char far *NombreFichero,TpEntradaDir far *pEntradaDir)
  {
     tpZSFA Arg={ DAME_NOMBRE_FICHERO, 0, 0 , NombreFichero , pEntradaDir , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_DameTipoFichero(char far *Ruta)
  {
     tpZSFA Arg={ DAME_TIPO_FICHERO, 0, 0 , Ruta , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

int ZSF_NumUnidadesMontadas(void)
  {
     tpZSFA Arg={ NUM_UNIDADES_MONTADAS, 0, 0 , 0 , 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
     return( Arg.S );
  }

void ZSF_DameUnidadesMontadas(TpInfoUnidadesMontadas far *UnidadesMontadas)
  {
     tpZSFA Arg={ DAME_UNIDADES_MONTADAS, 0, 0 , UnidadesMontadas, 0 , 0 , 0};
     ZEUS_enviar_mensaje( ZSF ,&Arg );
  }


