//
// Archivo    : ZSHELL.C
// Descripcin: Archivo de cdigo fuente del Shell asi como de todas las rutinas
//            de utilidad para el manejo de rutas, y otras cosas.
// Resp. Mant.: Javier Cuevas ( jcd@arrakis.es )
// Ult. Modif.: 27/07/97
//

#include <conio.H>
#include <stdio.H>
#include <stdlib.H>
#include <string.H>
#include <dos.H>
#include "ZGM\zmem.h"
#include "defines.h"	// Definiciones de 	ZEUS!
#include "tipos.h"	// Tipos de 		ZEUS!
#include "ZEUS.H"	// Servicios de 	ZEUS!
#include "memoria.h"	// Gestor de memoria.
#include "ZSF\CTRDISCO.H"
#include "ZSF\ERROR.H"
#include "ZSF\ZSF.H"
#include "ZGM\TiposMem.h"
#include "ZGM\mem.h"
#include "ZGM\ErrorMem.h"
#include "ZSF\Exec.h"
#include "ZGT\Tipos.h"
#include "ZGT\Zgt.h"

    //   Array con todos los errores que se pueden producir bajo ZEUS en una
    // ejecucin de Shell.
    TpError Errores[]={
      { NO_ERROR   ,"No error "},
      { CMD_INC    ,"Comando Incorrecto "},
      { ADR_N_FD   ,"Marca de direccion no encotrada "},
      { PROT_ESC   ,"Intento de escritura en un dico protegido contra escritura "},
      { SECT_N_FD  ,"Secto no encontrado "},
      { RST_FALL   ,"Reset fallido "},
      { DISK_EXTR  ,"Diskette fallido "},
      { TBL_INC    ,"Tabla de parametros incorrecta "},
      { DMA_RBDA   ,"DMA Rebasada "},
      { DMA_64KB   ,"DMA mas alla de limite de 64Kb "},
      { SECT_INC   ,"Indicador de sector incorrecto "},
      { CIL_INC    ,"Cilindro incorrecto "},
      { MEDIA_INC  ,"Tipo de media incorrecto "},
      { ST_FMT_IN  ,"Numero de sectores no valido en formato "},
      { M_DT_CTR   ,"Detectata marca de direccion de datos de control "},
      { ARB_F_RG   ,"Nivel de arbitraje de DMA fuera de rango "},
      { CRC_INC    ,"CRC o ECC incorrecto "},
      { ERR_ECC    ,"Error de datos corregidos por ECC "},
      { CTR_INC    ,"Fallo del controlador "},
      { BUSQ_INC   ,"Fallo en la busqueda "},
      { TIMEOUT    ,"Exceso de tiempo "},
      { NO_PREP    ,"Unidad no preparada "},
      { NO_DEF     ,"Error no definido "},
      { WRT_INC    ,"Fallo de escritura "},
      { ST_ERR     ,"Error de estado "},
      { DETECT_ER  ,"FAllo en operacion de deteccion "},
      /* Errores ZEUS " */
      { YA_INIT    ,"Sistema de ficheros ya inicializado "},
      { NO_INIT    ,"Sistema de ficheros no inicializado "},
      { YA_MOUNT   ,"Unidad ya montada "},
      { DIR_BUSY   ,"Directorio ya ocupado "},
      { ERR_RUTA   ,"La ruta especificada no existe "},
      { ES_DIR     ,"Es un directorio "},
      { ES_FICH    ,"Es un fichero  "},
      { NO_EXIST   ,"La ruta especificada no existe "},
      { NO_ES_DIR  ,"La ruta especificada no corresponde a DIR  "},
      { NO_ES_FICH ,"La ruta especificada no corresponde a FICH "},
      { NO_MEM     ,"No hay memoria disponible "},
      { FAT12      ,"Es una FAT de 12 bits "},
      { FAT16      ,"Es una FAT de 16 bits "},
      { DISC_LLENO ,"Disco lleno "},
      { ERR_CACHE  ,"Error idefinido en la cache "},
      { YA_EXIST   ,"La ruta especificada ya existe "},
      { NO_EN_RAIZ ,"No hay entradas libres en el directorio Raiz "},
      { MEM_ERR    ,"Error de memoria "},
      { SI_EXISTE  ,"El fichero si existe "},
      { NO_EXISTE  ,"El fichero no existe "},
      { ERR_NODEF  ,"Error indefinido "},
      { NO_VACIO   ,"Directorio no esta vacio"},
      { NO_HD      ,"La unidad no es un disco duro "},
      { NO_PART    ,"La Particion no existe "},
      { 0xFFFF     , ""}};

/* Declaramos un array de punteros a funciones */

/* Procedimientos */

void cat2(int Manejador);
int Ver(char far *s);
int CambiaDir(char far *Ruta,char far *Fichero);
int CambiaDirectorio(char far *Ruta,char far *Comando);
int Existefichero(char far *Ruta,char far *Fichero);
int ContenidoArchivo(char far *Comando);
int Ayuda(char far *Comando);
void AcercaDe(void);
int Montar(char far *Comando);
int Desmontar(char far *Comando);
int CreaDir(char far *Comando);
int NuevoFichero(char far *Comando);
int Borrar(char far *Comando);
int NumArgumentos(char far *Comando);
int Copia(char far *Comando);
char far *DameArgumentos(char far *Cadena,int Num);
char far *DameError(WORD Error);
int CalculaRuta(char far *RutaActual,char far *RutaRelativa);
int QuitaUltimoDeRuta(char far *Ruta,char far *Ultimo);
int Mem(char far *Comando);
int Exec(char far *Comando);
void ZeusDemo( void );
int Boot( unsigned int Valor );
/* Variables */
extern void Muestra_Lista_BCPs( void );
char DirectorioActual[256]="/";

/* Procesos externos */
extern TZIP ZSF;
extern TZIP ZeusVersion;
extern TZIP ZeusShell;

// Para ver que tal se sale
extern char SalidaCorrecta;

void Shell(void)
  {
    int Salir=FALSE;
    static char Buffer[256]="";

     while(!Salir)
       {
	 ZGT_Z_printf("[%s]# ",DirectorioActual);
	 ZGT_Z_gets(Buffer);
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"acercade")==0)
	   AcercaDe();
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"ayuda")==0)
	   Ayuda(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"borrar")==0)
	   Borrar(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"bp")==0)
	   clrscr();
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"cd")==0)
	   CambiaDirectorio(DirectorioActual,Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"cont")==0)
	   ContenidoArchivo(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"coolboot")==0)
	   Salir=Boot( 1 );
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"copia")==0)
	   Copia(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"creadir")==0)
	   CreaDir(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"desmontar")==0)
	   Desmontar(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"exec")==0)
	   Exec(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"mem")==0)
	   Mem(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"montar")==0)
	   Montar(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"nuevofichero")==0)
	   NuevoFichero(Buffer);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"procesos")==0)
	   Muestra_Lista_BCPs();
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"salir")==0)
	   Salir=TRUE;
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"ver")==0)
	   Ver(DirectorioActual);
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"warmboot")==0)
	   Salir=Boot( 2 );
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"zeusdemo")==0)
	   ZeusDemo();
	  else
	 if(strcmp(strlwr(DameArgumentos(Buffer,0)),"")==0);
	  else
	   ZGT_Z_printf("  \nComando o nombre de archivo incorrecto.\n\n");
       }
       SalidaCorrecta = 1;
  }

int Ayuda(char far *Comando)
  {
     strcpy(Comando,Comando);
     ZGT_Z_printf(" \n %s \n",VERSION);
     ZGT_Z_printf("     Listando comandos disponibles en esta version :\n\n");
     ZGT_Z_printf("        acercade      -  Muestra la version actual del shell.\n");
     ZGT_Z_printf("        ayuda         -  Muestra esta ayuda. \n");
     ZGT_Z_printf("        borrar        -  Borra el fichero especificado.\n");
     ZGT_Z_printf("        bp            -  Borra la pantalla.  \n");
     ZGT_Z_printf("        cd            -  Cambia de directorio.\n");
     ZGT_Z_printf("        cont          -  Muestra el contenido de un fichero.\n");
     ZGT_Z_printf("        coolboot      -  Arranque en frio.\n");
     ZGT_Z_printf("        copia         -  Copia ficheros.\n");
     ZGT_Z_printf("        creadir       -  Crea el directorio especificado.\n");
     ZGT_Z_printf("        desmontar     -  Desmonta una unidad montada en un directorio.\n");
     ZGT_Z_printf("        exec          -  Ejecuta aplicaciones del usuario .\n");
     ZGT_Z_printf("        mem           -  Muestra la cantidad de memoria disponible.\n");
     ZGT_Z_printf("        montar        -  Monta una unidad sobre un directorio.\n");
     ZGT_Z_printf("        nuevofichero  -  Crea un nuevo fichero con el nombre especificado.\n");
     ZGT_Z_printf("        procesos      -  Muestra los procesos actuales.\n");
     ZGT_Z_printf("        salir         -  Sale de shell.\n");
     ZGT_Z_printf("        ver           -  Muestra el contenido del directorio actual.\n");
     ZGT_Z_printf("        warmboot      -  Arranque en caliente.\n");
     ZGT_Z_printf("        zeusdemo      -  Hermosa demostracin de procesos en ZEUS.\n");
     ZGT_Z_printf("\n     Para saber mas escribir el nombre del comando sin argumentos.\n\n");
     return(NO_ERROR);
  }

void AcercaDe(void)
  {
     tpZSFA Arg;
     Arg.S=0;  /* Pedimos  la informacion de la vesion del nucleo */

     ZEUS_enviar_mensaje( ZeusVersion, &Arg);
     ZGT_Z_printf(" \n %s \n\n",VERSION);
     ZGT_Z_printf("     Sistema Operativo: %s\n",Arg.A);
     ZGT_Z_printf("     Creditos:\n");
     ZGT_Z_printf("        - Oscar Garca        - Jose Juan Barco\n");
     ZGT_Z_printf("        - Jos Luis Vela      - Javier Cuevas\n");
     ZGT_Z_printf("     Proyecto tutelado por:\n");
     ZGT_Z_printf("        - D.Tmas Corts.\n");
     ZGT_Z_printf("           (Profesor de la asignatura de Sistemas Operativos II)\n");
     ZGT_Z_printf("\n");
  }

int CreaDir(char far *Comando)
  {
     static char NombreFichero[128];
     int Error=NO_ERROR;
     int f;
     if(strcmp(strupr(DameArgumentos(Comando,1)),"")==0)
       { ZGT_Z_printf(" \n Error en argumentos. \n\n"); return(NO_ERROR+1); }
     /* Construimos la ruta Completa del fichero */
     strcpy(NombreFichero,DirectorioActual);
     if(strcmp(NombreFichero,"/")==0)
       strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
      else
       {
	strcat(NombreFichero,"/");
	strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
       }
     //  Error=CrearDirectorio(NombreFichero);
     Error=ZSF_CrearDirectorio(NombreFichero);
     if(Error!=NO_ERROR)
       {ZGT_Z_printf(" \n Error %s\n creando directorio %s.\n\n",DameError(Error),NombreFichero);return(Error);}
     return(Error);
  }

int Montar(char far *Comando)
  {  static char NombreFichero[128];
     WORD Unidad,Cont;
     char cUnidad;
     TpInfoUnidadesMontadas far *UdMontadas;
     int Error=NO_ERROR;
     int f;
     if(strcmp(strupr(DameArgumentos(Comando,1)),"")==0)
       {
	 Cont=ZSF_NumUnidadesMontadas();
	 UdMontadas=(TpInfoUnidadesMontadas far *)farmalloc(Cont*sizeof(TpInfoUnidadesMontadas));
	 if(UdMontadas==NULL)
	   { ZGT_Z_printf(" \n Error! %s. \n\n",DameError(NO_MEM)); return(NO_MEM); }
	 ZSF_DameUnidadesMontadas(UdMontadas);
	 ZGT_Z_printf(" \n    Total unidades montadas en el sistema : %u Ud.\n\n",Cont);;
	 ZGT_Z_printf("      %-30s  %4s %9s %9s %9s\n"," Ruta completa","Unid","Total","Libre","Ocup");
	 ZGT_Z_printf("       ------------------------------------------------------------------------\n");
	 for(Unidad=0;Unidad<Cont;Unidad++)
	   ZGT_Z_printf("      %-30s 0x%02X %9lu %9lu %9lu\n",
		   UdMontadas[Unidad].Ruta,
		   UdMontadas[Unidad].UnidadBIOS,
		   UdMontadas[Unidad].BytesTotales,
		   UdMontadas[Unidad].BytesLibres,
		   UdMontadas[Unidad].BytesOcupados);
	 ZGT_Z_printf("\n");
	 farfree(UdMontadas);
	 return(NO_ERROR);
       }
     if((strcmp(strupr(DameArgumentos(Comando,1)),"")==0) ||
	 (strcmp(strupr(DameArgumentos(Comando,2)),"")==0))
       { ZGT_Z_printf(" \n Error en argumentos. \n\n"); return(NO_ERROR+1); }
     /* Construimos la ruta Completa del fichero */
     strcpy(NombreFichero,DirectorioActual);
     if(strcmp(NombreFichero,"/")==0)
       strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
      else
       {
	strcat(NombreFichero,"/");
	strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
       }
     Unidad=atoi(DameArgumentos(Comando,2));
     Error=ZSF_MontarUnidad(Unidad,NombreFichero);
     if(Error!=NO_ERROR)
       {ZGT_Z_printf(" \n Error %s\n montando unidad %i sobre %s.\n\n",DameError(Error),Unidad,NombreFichero);return(Error);}
     return(Error);
  }

int Desmontar(char far *Comando)
  {  static char NombreFichero[128];
     int Error=NO_ERROR;
     int f;
     if(strcmp(strupr(DameArgumentos(Comando,1)),"")==0)
       { ZGT_Z_printf(" \n Error en argumentos. \n\n"); return(NO_ERROR+1); }
     /* Construimos la ruta Completa del fichero */
     strcpy(NombreFichero,DirectorioActual);
     if(strcmp(NombreFichero,"/")==0)
       strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
      else
       {
	strcat(NombreFichero,"/");
	strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
       }
     Error=ZSF_DesmontarUnidad(NombreFichero);
     if(Error!=NO_ERROR)
       {ZGT_Z_printf(" \n Error %s\n Desmontando unidad %s.\n\n",DameError(Error),NombreFichero);return(Error);}
     return(Error);
  }

int CambiaDirectorio(char far *Ruta,char far *Comando)
  { static char RutaTmp[128];
    static char RutaRel[128];
    int Error;

    switch(NumArgumentos(Comando)) {
      case 1: /* Sin parametros */
	ZGT_Z_printf(" \n   Cambiadir [<Ruta>] \n\n");
	ZGT_Z_printf("    - Cambia al directorio especificado en Ruta.\n");
	ZGT_Z_printf("       Si se omite Ruta sale esta ayuda.\n\n");
	return(NO_ERROR);
      case 2: /* Se ha especificado ruta */
	/* Obtenemos la ruta especificada */
	strcpy(RutaRel,strupr(DameArgumentos(Comando,1)));
	break;
      default:
	ZGT_Z_printf("\n  Error! Demasiados paramentros. \n\n");
	return(NO_ERROR);
      }
    strcpy(RutaTmp,Ruta); /* Hacemos una copia de la ruta actual */
    /* Calculamos la ruta absoluta a partir de la ruta actual y la relativa */
    Error=CalculaRuta(RutaTmp,RutaRel);
    if(Error!=NO_ERROR)
     { ZGT_Z_printf("\n  Error! %s. \n\n",DameError(Error)); return(Error); }
    /* En RutaTmp esta la ruta absoluta correcta */
    strcpy(Ruta,RutaTmp);
    return(NO_ERROR);
  }

int CambiaDir(char far *Ruta,char far *Fichero)
  { static char NombreDir[128];
    static char RutaTmp[128];

    strcpy(NombreDir,strupr(Fichero));
    if(strcmp(NombreDir,"/")==0)
      strcpy(Ruta,"/");
     else
    if(strcmp(NombreDir,".")==0)
      strcpy(Ruta,Ruta);
     else
    if(strcmp(NombreDir,"..")==0 && strcmp(Ruta,"/")!=0)
      {
	int Cont=strlen(Ruta);
	while(Ruta[Cont]!='/')
	  Cont--;
	Ruta[Cont]=0;
	if(strlen(Ruta)==0)
	   strcpy(Ruta,"/");
      }
     else
      { /* Creamos la ruta completa */
	strcpy(RutaTmp,Ruta);
	if(strcmp(Ruta,"/")==0)
	  strcat(RutaTmp,NombreDir);
	 else
	  {
	    strcat(RutaTmp,"/");
	    strcat(RutaTmp,NombreDir);
	  }
	switch(ZSF_DameTipoFichero(RutaTmp)) {
	  case ES_FICH:
	  case ERR_RUTA:
	  case NO_EXIST:
	    return(ERR_RUTA);
	  case ES_DIR:
	    strcpy(Ruta,RutaTmp);
	}
      }
    return(NO_ERROR);
  }

int ContenidoArchivo(char far *Comando)
  {  static char NombreFichero[128];
     int Error=NO_ERROR;
     int f;
     /* Construimos la ruta Completa del fichero */
     strcpy(NombreFichero,DirectorioActual);
     if(strcmp(NombreFichero,"/")==0)
       strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
      else
       {
	strcat(NombreFichero,"/");
	strcat(NombreFichero,strupr(DameArgumentos(Comando,1)));
       }
     /* Abrimos el fichero */
     Error=ZSF_AbrirFichero(&f,NombreFichero);
     if(Error!=NO_ERROR)
       {ZGT_Z_printf(" \n Error! %s\n Abriendo fichero %s.\n\n",DameError(Error),NombreFichero);return(Error);}
     cat2(f);
     Error=ZSF_CerrarFichero(f);
     if(Error!=NO_ERROR)
       {ZGT_Z_printf(" \n Error! %s\n Abriendo fichero %s.\n\n",DameError(Error),NombreFichero);return(Error);}
     ZGT_Z_printf("\n");
     return(NO_ERROR);
  }

int Existefichero(char far *Ruta,char far *Fichero)
  {
   WORD NumEntradas;
   TpEntradaDir far *pEntradaDir;
   int Error=NO_ERROR,Cont;
   DWORD TotalBytes;

   Error=ZSF_NumEntradasEnDirectorio(Ruta,&NumEntradas);
   if(Error!=NO_ERROR)
     return(Error);
   pEntradaDir=(TpEntradaDir *)farmalloc((NumEntradas+1)*sizeof(TpEntradaDir));
   if(pEntradaDir==NULL)
     return(Error);
   Error=ZSF_ListaArchivos(Ruta,pEntradaDir);
   if(Error!=NO_ERROR)
     return(Error);

   for(Cont=0;Cont<NumEntradas;Cont++)
      { char s[20];
	ZSF_DameNombreFichero(s,&pEntradaDir[Cont]);
	if(strcmp(Fichero,s)==0)
	  { /* Si existe */
	    farfree(pEntradaDir);
	    return(SI_EXISTE);
	  }
      }
   farfree(pEntradaDir);
   return(NO_EXISTE);
  }

int Ver(char far *s)
 {

   WORD NumEntradas=1234;
   TpEntradaDir far *pEntradaDir;
   int Error=NO_ERROR,Cont;
   DWORD TotalBytes=0;
   Error=ZSF_NumEntradasEnDirectorio(s,&NumEntradas);
   if(Error!=NO_ERROR)
     return(Error);
   pEntradaDir=(TpEntradaDir *)farmalloc((NumEntradas)*sizeof(TpEntradaDir));
   if(pEntradaDir==NULL)
     return(Error);
   Error=ZSF_ListaArchivos(s,pEntradaDir);
   if(Error!=NO_ERROR)
     return(Error);
   ZGT_Z_printf(" \n Contenido de %s\n\n",s);
   for(Cont=0;Cont<NumEntradas;Cont++)
      { char s[20];
	DameNombreFichero(s,&pEntradaDir[Cont]);
	ZGT_Z_printf(" %12s  %10lu bytes",s,pEntradaDir[Cont].LongEnBytes);
	if((pEntradaDir[Cont].Atributos & B_DIRECTORIO)==B_DIRECTORIO)
	  ZGT_Z_printf(" -> Directorio. \n");
	 else
	  ZGT_Z_printf(" -> Fichero. \n");
	TotalBytes+=pEntradaDir[Cont].LongEnBytes;
      }
   ZGT_Z_printf("      Un total de %i entradas ocupan %lu bytes.\n\n",NumEntradas,TotalBytes);
   farfree(pEntradaDir);
   return(NO_ERROR);
 }

void cat2(int Manejador)
  {
     int NumLineas=0;
     /* Mostramos el contenido del fichero */
     char far *Buffer;
     DWORD BytesLeidos;
     int Error,Cont;
     /* Reservamos memoria para el buffer */
     Buffer=(char far *)farmalloc(2000);

     while( !ZSF_Eof(Manejador) )
       { BytesLeidos=ZSF_LeerFichero(Manejador,1920,Buffer);
	 for(Cont=0;Cont<BytesLeidos;Cont++)
	  {
	    ZGT_Z_putch(Buffer[Cont],0,0);
	    if(Buffer[Cont]=='\n')
	      NumLineas++;
	    if( NumLineas>22 )
	      { ZGT_Z_printf( "\n Pulse una tecla para continuar.");
		ZGT_Z_getch();
		ZGT_Z_printf("\n");
		NumLineas=0;
	      }
	  }
       }
  }

char far *DameError(WORD Error)
  {
    int Cont=0;

    while(Errores[Cont].TipoError!=Error && Errores[Cont].TipoError!=0xFFFF)
      Cont++;
    return(Errores[Cont].DescripcionError);
  }

char far *DameArgumentos(char far *Cadena,int Num)
  { int Cont=0,iTmp=0,Cont2=0;
    static char Tmp[128]="";
    for(Cont=0;Cont<128;Cont++)
      Tmp[Cont]=0;
    /* Ignoramos los espacios al inicio */
    while(Cadena[iTmp]==' ' && iTmp<strlen(Cadena))
      iTmp++;
    Cont=0;
    /* Hasta que no de con el elemento que me piden */
    while(Cont<Num && iTmp<strlen(Cadena))
      { /* Busco el siguiente elemento */
	while(Cadena[iTmp]!=' ' && iTmp<strlen(Cadena))
	  iTmp++;
	Cont++;
	/* Ignoramos los espacios al inicio */
	while(Cadena[iTmp]==' ' && Cadena[iTmp]!=0)
	  iTmp++;
      }
    while(Cadena[iTmp]!=' ' && Cadena[iTmp]!=0)
      Tmp[Cont2++]=Cadena[iTmp++];
    return(Tmp);
  }

int NumArgumentos(char far *Comando)
  { int Cont=0,iTmp=0;

    /* Ignoramos los espacios al inicio */
    while(Comando[iTmp]==' ' && iTmp<strlen(Comando))
      iTmp++;
    Cont=0;
    /* Hasta que no se acaben los todos los argumentos */
    while(iTmp<strlen(Comando))
      { /* Busco el siguiente elemento */
	while(Comando[iTmp]!=' ' && iTmp<strlen(Comando))
	  iTmp++;
	Cont++;
	/* Ignoramos los espacios al inicio */
	while(Comando[iTmp]==' ' && Comando[iTmp]!=0)
	  iTmp++;
      }
    return(Cont);
  }

int CalculaRuta(char far *RutaActual,char far *RutaRelativa)
  {
    char NombreDir[15]="";
    int Cont=0;
    int Error;

    if(RutaRelativa[0]=='/')
      { /* Ruta especificada desde el directorio raiz */
	/* Cambiamos al directorio raiz */
	Error=CambiaDir(RutaActual,"/");
	if(Error!=NO_ERROR)
	  return(Error);
	/* Eliminamos el caracter '/' del principio */
	strcpy(RutaRelativa,&RutaRelativa[1]);
      }

    while(strlen(RutaRelativa)>0)
     { /* Copiamos en NombreDir el nuevo nombre de directorio */
       Cont=0;
       while(RutaRelativa[Cont]!=0 && RutaRelativa[Cont]!='/')
	 { NombreDir[Cont]=RutaRelativa[Cont]; Cont++; }
       NombreDir[Cont]=0;
       /* Cambiamos al Nuevo Directorio */
       Error=CambiaDir(RutaActual,NombreDir);
       if(Error!=NO_ERROR)
	  return(Error);
	/* Eliminamos el directorio NombreDir de la Ruta */
	if(RutaRelativa[Cont]=='/')
	  Cont++;
	strcpy(RutaRelativa,&RutaRelativa[Cont]);
     }
    return(NO_ERROR);
  }

int QuitaUltimoDeRuta(char far *Ruta,char far *Ultimo)
  {
    int Cont=strlen(Ruta)-1;
    while(Cont>0 && Ruta[Cont]!='/')
      Cont--;
    if(Ruta[Cont]=='/')
      strcpy(Ultimo,&Ruta[Cont+1]);
     else
      strcpy(Ultimo,Ruta);
    Ruta[Cont+1]=0;
    if(strcmp(Ruta,"/")!=0)
      Ruta[Cont]=0;
    return(NO_ERROR);
  }

int Copia(char far *Comando)
  {
    #define LONG_BUFFER 512*8

    int f1,f2;
    int Error=NO_ERROR;
    static char Origen[126], Destino[126], Fichero[15];
    static char Tmp[126];
    DWORD BytesACopiar=0,BytesLeidos=0,BytesTotales=0,NumEntradas;
    /* Estatica para que no se cree en la pila */
    static char Buffer[LONG_BUFFER];    /* Tamao del buffer intermedio */

    strcpy(Destino,DirectorioActual); /* Opcion por defecto */

    switch (NumArgumentos(Comando)) {
      case 1: /* Sin parametros */
	ZGT_Z_printf(" \n   Copia [<Origen>] [<Destino>] \n\n");
	ZGT_Z_printf("    - Copia un el fichero especificado en origen en destino.\n");
	ZGT_Z_printf("       Si se omite un destino, el fichero se copia en el directorio\n");
	ZGT_Z_printf("       actual. Si no se le pasan parametros sale esta ayuda.\n\n");
	return(NO_ERROR);
      case 3: /* Se ha especificado origen y destino */
	/* Copiamos Destino */
	strcpy(Tmp,strupr(DameArgumentos(Comando,2)));
	/* Quitamos el nombre del fichero de la ruta */
	QuitaUltimoDeRuta(Tmp,Fichero);
	/* Convertimos a ruta absoluta */
	Error=CalculaRuta(Destino,Tmp);
	if(Error!=NO_ERROR)
	 { ZGT_Z_printf(" \n  Error! Ruta no vlida. \n\n"); return(ERR_RUTA); }
	/* Aadimos de nuevo el nombre del fichero a la ruta */
	if(strcmp(Destino,"/")==0)
	  strcat(Destino,Fichero);
	 else
	  {strcat(Destino,"/"); strcat(Destino,Fichero); }
      case 2: /* Solo se ha especificado Origen */
	/* Copiamos Origen */
	strcpy(Tmp,strupr(DameArgumentos(Comando,1)));
	/* Quitamos el nombre del fichero de la ruta */
	QuitaUltimoDeRuta(Tmp,Fichero);
	strcpy(Origen,DirectorioActual);
	/* Convertimos a ruta absoluta */
	Error=CalculaRuta(Origen,Tmp);
	if(Error!=NO_ERROR)
	 { ZGT_Z_printf(" \n  Error! Ruta no vlida. \n\n"); return(ERR_RUTA); }
	/* Aadimos de nuevo el nombre del fichero a la ruta */
	if(strcmp(Origen,"/")==0)
	  strcat(Origen,Fichero);
	 else
	  {strcat(Origen,"/"); strcat(Origen,Fichero); }
      }
    /* Comprobamos que origen sea un fichero */
    switch(ZSF_DameTipoFichero(Origen)) {
      case ES_DIR: /* La ruta en Origen corresponde a un directorio */
	ZGT_Z_printf("\n Error! El nombre en Origen (%s) es un directorio.\n\n",Origen);
	return(ES_DIR);
      case NO_EXIST: /* Ruta en origen incorrecta */
	ZGT_Z_printf("\n Error! El nombre en Origen (%s) no existe.\n\n",Origen);
	return(NO_EXIST);
      }
    /* Comprobamos que es Destino */
    switch(ZSF_DameTipoFichero(Destino)) {
      case ES_DIR:
	/* Se aade el nombre del fichero en origen como nombre del fichero */
	/*    en destino. */
	strcat(Tmp,Origen);
	QuitaUltimoDeRuta(Tmp,Fichero);
	/* Aadimos de nuevo el nombre del fichero a la ruta */
	if(strcmp(Destino,"/")==0)
	  strcat(Destino,Fichero);
	 else
	  {strcat(Destino,"/"); strcat(Destino,Fichero); }
	break;
      case ES_FICH: /* La ruta en destino existe */
	/* Se borra el fichero */
	Error=ZSF_BorrarFichero(Destino);
	if(Error!=NO_ERROR)
	  { ZGT_Z_printf(" Error! %s.\n\n",DameError(Error)); return(Error); }
      }
    /* Creamos el fichero en destino */
    Error=ZSF_CrearFichero(Destino);
    if(Error!=NO_ERROR)
      { ZGT_Z_printf(" Error! %s, al crear fichero.\n\n",DameError(Error)); return(Error); }
    /* Abrimos fichero Origen */
    Error=ZSF_AbrirFichero(&f1,Origen);
    if(Error!=NO_ERROR)
      { ZGT_Z_printf(" Error! %s, al abrir Origen.\n\n",DameError(Error)); return(Error); }
    /* Abrimos fichero Destino */
    Error=ZSF_AbrirFichero(&f2,Destino);
    if(Error!=NO_ERROR)
      { ZGT_Z_printf(" Error! %s, al abrir Destino.\n\n",DameError(Error)); return(Error); }
    BytesACopiar=ZSF_LongFichero(f1);
    ZGT_Z_printf("   Copiando %s en %s.\n",Origen,Destino);
    ZGT_Z_printf("   Total bytes a copiar:  %12lu Bytes\n",BytesACopiar);
    ZGT_Z_printf("   Bytes Copiados: %12lu    Bytes Por Copiar %12lu",BytesTotales,BytesACopiar-BytesTotales);
    while(!Eof(f1))
      {
	{ int Cont;
	  for(Cont=0;Cont<strlen("   Bytes Copiados:     Bytes Por Copiar ")+24;Cont++)
	    ZGT_Z_printf("%c",8);
	}
	BytesLeidos=ZSF_LeerFichero(f1,LONG_BUFFER,Buffer);
	Error=ZSF_EscribirFichero(f2,BytesLeidos,Buffer);
	if(Error)
	  { ZGT_Z_printf(" \n Error! %s, al escribir fichero. \n\n",DameError(Error)); break; }
	BytesTotales+=BytesLeidos;
	ZGT_Z_printf("   Bytes Copiados: %12lu    Bytes Por Copiar %12lu",BytesTotales,BytesACopiar-BytesTotales);
      }
    ZSF_CerrarFichero(f1);
    ZSF_CerrarFichero(f2);
    ZGT_Z_printf("\n   1 Archivo copiado.\n\n");
    return(Error);
  }

int NuevoFichero(char far *Comando)
  {
    int Error=NO_ERROR;
    static char Destino[126], Fichero[15];
    static char Tmp[126];

    strcpy(Destino,DirectorioActual); /* Opcion por defecto */

    switch (NumArgumentos(Comando)) {
      case 1: /* Sin parametros */
	ZGT_Z_printf(" \n   CrearFichero [<Destino>] \n\n");
	ZGT_Z_printf("    - Crea el fichero especificado en destino.\n");
	ZGT_Z_printf("       Si no se le pasan parametros sale esta ayuda.\n\n");
	return(NO_ERROR);
      case 2: /* Se ha especificado origen y destino */
	/* Copiamos Destino */
	strcpy(Tmp,strupr(DameArgumentos(Comando,1)));
	/* Quitamos el nombre del fichero de la ruta */
	QuitaUltimoDeRuta(Tmp,Fichero);
	/* Convertimos a ruta absoluta */
	Error=CalculaRuta(Destino,Tmp);
	if(Error!=NO_ERROR)
	 { ZGT_Z_printf(" \n  Error! Ruta no vlida. \n\n"); return(ERR_RUTA); }
	/* Aadimos de nuevo el nombre del fichero a la ruta */
	if(strcmp(Destino,"/")==0)
	  strcat(Destino,Fichero);
	 else
	  {strcat(Destino,"/"); strcat(Destino,Fichero); }
	break;
      default:
	ZGT_Z_printf("\n  Numero de argumentos invalido. \n\n");
	return(NO_ERROR);
      }
    /* Verificamos que el fichero Destino no exista */
    switch(ZSF_DameTipoFichero(Destino)) {
      case ES_DIR:
	ZGT_Z_printf("\n Error! Fichero especificado es un directorio.\n\n");
	return(ES_DIR);
      case ES_FICH:
	ZGT_Z_printf("\n Error! El fichero especificado ya existe.\n\n");
	return(ES_FICH);
      }
    Error=ZSF_CrearFichero(Destino);
    if(Error!=NO_ERROR)
      ZGT_Z_printf("\n Error! %s, al crear fichero.\n\n",DameError(Error));
    return(Error);
  }

int Borrar(char far *Comando)
  {
    int Error=NO_ERROR;
    static char Destino[126], Fichero[15];
    static char Tmp[126];

    strcpy(Destino,DirectorioActual); /* Opcion por defecto */

    switch (NumArgumentos(Comando)) {
      case 1: /* Sin parametros */
	ZGT_Z_printf(" \n   Borrar [<Destino>] \n\n");
	ZGT_Z_printf("    - Borra el fichero o directorio especificado en destino.\n");
	ZGT_Z_printf("       Si no se le pasan parametros muestra esta ayuda.\n\n");
	return(NO_ERROR);
      case 2: /* Se ha especificado origen y destino */
	/* Copiamos Destino */
	strcpy(Tmp,strupr(DameArgumentos(Comando,1)));
	/* Quitamos el nombre del fichero de la ruta */
	QuitaUltimoDeRuta(Tmp,Fichero);
	/* Convertimos a ruta absoluta */
	Error=CalculaRuta(Destino,Tmp);
	if(Error!=NO_ERROR)
	 { ZGT_Z_printf(" \n  Error! Ruta no vlida. \n\n"); return(ERR_RUTA); }
	/* Aadimos de nuevo el nombre del fichero a la ruta */
	if( strcmp(Destino,"/" )==0)
	  strcat(Destino,Fichero);
	 else
	  {strcat(Destino,"/"); strcat(Destino,Fichero); }
	break;
      default:
	ZGT_Z_printf("\n  Numero de argumentos invalido. \n\n");
	return(NO_ERROR);
      }
    /* Verificamos que el fichero Destino si exista */
    switch(ZSF_DameTipoFichero(Destino)) {
      case ES_DIR:
	Error=ZSF_BorrarDirectorio(Destino);
	if(Error!=NO_ERROR)
	  ZGT_Z_printf("\n Error! %s, al borrar directorio.\n\n",DameError(Error));
	return(Error);
      case NO_EXIST:
	ZGT_Z_printf("\n Error! El fichero especificado no existe.\n\n");
	return(NO_EXIST);
      }
    Error=ZSF_BorrarFichero(Destino);
    if(Error!=NO_ERROR)
      ZGT_Z_printf("\n Error! %s, al borrar fichero.\n\n",DameError(Error));
    return(Error);
  }
/* Parametro externo necesario */
extern TpAplic ListaAplicUsusario[];

int Exec(char far *Comando)
  {
    int Error=NO_ERROR,Cont=0;
    static char Tmp[126];

    switch (NumArgumentos(Comando)) {
      case 1: /* Sin parametros */
	ZGT_Z_printf(" \n   Exec [<Aplicacio>|</Lista>] \n\n");
	ZGT_Z_printf("    - Ejecuta la aplicacion de usuario especificada.\n");
	ZGT_Z_printf("       El parametro Lista, muestra una lista de las aplicaciones\n");
	ZGT_Z_printf("         disponibles.\n");
	ZGT_Z_printf("       Si no se le pasan parametros  muestra esta ayuda.\n\n");
	return(NO_ERROR);
      case 2:
	strcpy(Tmp,strlwr( DameArgumentos(Comando,1) ) );
	if(strcmp(Tmp,"/lista")==0)
	  { /* Mostramos la lista de aplicaciones disponible */
	    ZGT_Z_printf("\n     Mostrado lista de aplicaciones disponibles :\n\n");
	    while( ListaAplicUsusario[Cont].Ocupado )
	      { ZGT_Z_printf("      - %s\n",&(ListaAplicUsusario[Cont].Nombre[0]));
		Cont++;
	      }
	    ZGT_Z_printf("\n");
	    return(Error);
	  }
	/* Tenemos que lanzar la aplicacion pedida */
	while( ListaAplicUsusario[Cont].Ocupado )
	  { if(strcmp(Tmp,strlwr(ListaAplicUsusario[Cont].Nombre))==0)
	     { /* Aplicacion encontrada */
	       FuncUsuario(Cont); // ejecutamos la alplicacion
	       return(Error);
	     }
	    Cont++;
	  }
	ZGT_Z_printf("\n Exec: Aplicacion especificada [%s]no existe.\n\n",Tmp);
	return(NO_EXIST);
      default:
	  ZGT_Z_printf("\n Exec: Numero de argumentos invalido \n\n");
	  return(Error);
      }
  }

int Mem(char far *Comando)
  {
    int Error=NO_ERROR;  //,Cont=0;
    int Mascara=0x10;   // Mascara por defecto.
    int NumParametros=0,Ayuda=FALSE;
    static char cTmp[126];
    char far *Zip;
    switch (NumParametros=NumArgumentos(Comando)) {
      case 1:
	MuestraListaBCPMs( Mascara, 0  );
	break;
      default: /* con parametros */
	while( NumParametros >1 )
	  {  // Cogemos el siguiente parametro
	     strcpy(cTmp,strlwr(DameArgumentos(Comando,NumParametros-1)));
	     if( strcmp(cTmp,"/?") == 0 )
	       Ayuda=TRUE;
	     else if( strcmp(cTmp,"/p") == 0 )  // Pausa
	       Mascara|=0x8;
	     else if( strcmp(cTmp,"/c") == 0 )  // Cabecera
	       Mascara|=(~0x1);
	     else if( strcmp(cTmp,"/t") == 0 )  // Todos los procesos
	       { Mascara|=  0x2;
		 Mascara&=(~0x4);
		 Mascara|=  0x1; }
	     else if( strncmp(cTmp,"/i:",3) == 0 )  // Filtro por Zip
	       { Zip=&cTmp[3];
		 Mascara|=0x2;
		 Mascara|=0x4;
		 Mascara|=0x1; }
	     else
	       { ZGT_Z_printf("\n Parametro {%s} no valido.\n\n",cTmp);
		 return(1);
	       }
	     NumParametros--;
	  }
	if(Ayuda)
	  {
	     ZGT_Z_printf(" \n   Mem [</?>] [</c>] [</p>] [</t>] [</i:ZIP>]  \n\n");
	     ZGT_Z_printf("    - Muestra informacin referente a la memoria del sistema.\n");
	     ZGT_Z_printf("       Parametros disponibles :\n");
	     ZGT_Z_printf("           [</?>] Muestra esta ayuda.\n");
	     ZGT_Z_printf("           [</c>] Quita la cabecera del listado.\n");
	     ZGT_Z_printf("           [</p>] Activa la pausa.\n");
	     ZGT_Z_printf("           [</t>] Muestra lista de BCPM's.\n");
	     ZGT_Z_printf("           [</i:ZIP>] Muestra lista de BCPM's del proceso ZIP.\n");
	     ZGT_Z_printf("\n\n");
	     return(NO_ERROR);
	  }
	// Mostramos la lista
	MuestraListaBCPMs( Mascara, Zip  );
      }
    return(Error);
  }

extern int Rebootar;

int Boot( unsigned int Valor )
  {
    switch( Valor ) {
      case 1: Rebootar=1; return( TRUE );
      case 2: Rebootar=2; return( TRUE );
    }
    return(FALSE);
  }
