/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;
import asf.AsfStream;

public class BitmapInfoHeader {
    private int objectSize;
    private int imageWidth;
    private int imageHeight;
    private int biPlanes;
    private int bitsPerPixelCount;
    private int compressionID;
    private int imageSize;
    private int horizontalPixelsPerMeter;
    private int verticalPixelsPerMeter;
    private int colorsUsedCount;
    private int importantColorsCount;
    private int codecSpecificData;

    public BitmapInfoHeader(AsfStream asfStream, int n) {
        this.objectSize = n;
        this.imageWidth = asfStream.getWidth();
        this.imageHeight = asfStream.getHeight();
        this.biPlanes = 1;
        this.bitsPerPixelCount = 24;
        this.compressionID = this.setCompressionID(asfStream.getCodec());
    }

    public BitmapInfoHeader(byte[] byArray, int n, int n2) {
        this.objectSize = (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
        if (this.objectSize != n2) {
            System.out.println("BitmapInfoHeader : objectSize  != dataLength : " + this.objectSize + "  :  " + n2);
        }
        this.imageWidth = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
        this.imageHeight = (byArray[n + 8] & 0xFF) + ((byArray[n + 9] & 0xFF) << 8) + ((byArray[n + 10] & 0xFF) << 16) + ((byArray[n + 11] & 0xFF) << 24);
        this.biPlanes = (byArray[n + 12] & 0xFF) + ((byArray[n + 13] & 0xFF) << 8);
        this.bitsPerPixelCount = (byArray[n + 14] & 0xFF) + ((byArray[n + 15] & 0xFF) << 8);
        this.compressionID = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.imageSize = (byArray[n + 20] & 0xFF) + ((byArray[n + 21] & 0xFF) << 8) + ((byArray[n + 22] & 0xFF) << 16) + ((byArray[n + 23] & 0xFF) << 24);
        this.horizontalPixelsPerMeter = (byArray[n + 24] & 0xFF) + ((byArray[n + 25] & 0xFF) << 8) + ((byArray[n + 26] & 0xFF) << 16) + ((byArray[n + 27] & 0xFF) << 24);
        this.verticalPixelsPerMeter = (byArray[n + 28] & 0xFF) + ((byArray[n + 29] & 0xFF) << 8) + ((byArray[n + 30] & 0xFF) << 16) + ((byArray[n + 31] & 0xFF) << 24);
        this.colorsUsedCount = (byArray[n + 32] & 0xFF) + ((byArray[n + 33] & 0xFF) << 8) + ((byArray[n + 34] & 0xFF) << 16) + ((byArray[n + 35] & 0xFF) << 24);
        this.importantColorsCount = (byArray[n + 36] & 0xFF) + ((byArray[n + 37] & 0xFF) << 8) + ((byArray[n + 38] & 0xFF) << 16) + ((byArray[n + 39] & 0xFF) << 24);
        if (this.objectSize >= 44) {
            this.codecSpecificData = (byArray[n + 40] & 0xFF) + ((byArray[n + 41] & 0xFF) << 8) + ((byArray[n + 42] & 0xFF) << 16) + ((byArray[n + 43] & 0xFF) << 24);
        }
    }

    String getCodecString() {
        String string = "---";
        if (this.compressionID == 844516695) {
            string = "wmv2";
        } else if (this.compressionID == 861293911) {
            string = "wmv3";
        }
        return string;
    }

    int setCompressionID(String string) {
        if (string.equals("WMV2")) {
            return 844516695;
        }
        if (string.equals("WMV3")) {
            return 861293911;
        }
        return 0;
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        byArray[0] = (byte)this.objectSize;
        byArray[1] = (byte)(this.objectSize >> 8);
        byArray[2] = (byte)(this.objectSize >> 16);
        byArray[3] = (byte)(this.objectSize >> 24);
        byArray[4] = (byte)this.imageWidth;
        byArray[5] = (byte)(this.imageWidth >> 8);
        byArray[6] = (byte)(this.imageWidth >> 16);
        byArray[7] = (byte)(this.imageWidth >> 24);
        byArray[8] = (byte)this.imageHeight;
        byArray[9] = (byte)(this.imageHeight >> 8);
        byArray[10] = (byte)(this.imageHeight >> 16);
        byArray[11] = (byte)(this.imageHeight >> 24);
        byArray[12] = (byte)this.biPlanes;
        byArray[13] = (byte)(this.biPlanes >> 8);
        byArray[14] = (byte)this.bitsPerPixelCount;
        byArray[15] = (byte)(this.bitsPerPixelCount >> 8);
        byArray[16] = (byte)this.compressionID;
        byArray[17] = (byte)(this.compressionID >> 8);
        byArray[18] = (byte)(this.compressionID >> 16);
        byArray[19] = (byte)(this.compressionID >> 24);
        byArray[20] = (byte)this.imageSize;
        byArray[21] = (byte)(this.imageSize >> 8);
        byArray[22] = (byte)(this.imageSize >> 16);
        byArray[23] = (byte)(this.imageSize >> 24);
        byArray[24] = (byte)this.horizontalPixelsPerMeter;
        byArray[25] = (byte)(this.horizontalPixelsPerMeter >> 8);
        byArray[26] = (byte)(this.horizontalPixelsPerMeter >> 16);
        byArray[27] = (byte)(this.horizontalPixelsPerMeter >> 24);
        byArray[28] = (byte)this.verticalPixelsPerMeter;
        byArray[29] = (byte)(this.verticalPixelsPerMeter >> 8);
        byArray[30] = (byte)(this.verticalPixelsPerMeter >> 16);
        byArray[31] = (byte)(this.verticalPixelsPerMeter >> 24);
        byArray[32] = (byte)this.colorsUsedCount;
        byArray[33] = (byte)(this.colorsUsedCount >> 8);
        byArray[34] = (byte)(this.colorsUsedCount >> 16);
        byArray[35] = (byte)(this.colorsUsedCount >> 24);
        byArray[36] = (byte)this.importantColorsCount;
        byArray[37] = (byte)(this.importantColorsCount >> 8);
        byArray[38] = (byte)(this.importantColorsCount >> 16);
        byArray[39] = (byte)(this.importantColorsCount >> 24);
        if (this.objectSize >= 44) {
            byArray[40] = (byte)this.codecSpecificData;
            byArray[41] = (byte)(this.codecSpecificData >> 8);
            byArray[42] = (byte)(this.codecSpecificData >> 16);
            byArray[43] = (byte)(this.codecSpecificData >> 24);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 4);
        stringBuffer.append("\t\t Format Data Size : " + this.objectSize + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 4, 4);
        stringBuffer.append("\t\t Image Width : " + this.imageWidth + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 8, 4);
        stringBuffer.append("\t\t Image Height : " + this.imageHeight + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 12, 2);
        stringBuffer.append("\t\t Reserved  ( biPlanes ) : " + this.biPlanes + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 14, 2);
        stringBuffer.append("\t\t Bits Per Pixel Count : " + this.bitsPerPixelCount + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 4);
        stringBuffer.append("\t\t Compression ID : " + this.compressionID + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 20, 4);
        stringBuffer.append("\t\t Image Size : " + this.imageSize + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 4);
        stringBuffer.append("\t\t Horizontal Pixels Per Meter : " + this.horizontalPixelsPerMeter + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 28, 4);
        stringBuffer.append("\t\t Vertical Pixels Per Meter : " + this.verticalPixelsPerMeter + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 32, 4);
        stringBuffer.append("\t\t Colors Used Count : " + this.colorsUsedCount + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 36, 4);
        stringBuffer.append("\t\t Important Colors Count : " + this.importantColorsCount + "\n");
        if (this.objectSize >= 44) {
            AsfHeader.appendHexString(stringBuffer, byArray, 40, 4);
            stringBuffer.append("\t\t Codec Specific Data: " + this.codecSpecificData + "\n");
        }
        return stringBuffer.toString();
    }
}

