/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.MMSCommand;
import asf.MMSServer;

class ClientCommandParser {
    private MMSCommand mms = new MMSCommand();
    private MMSServer server;
    private int commandValue;

    public ClientCommandParser(MMSServer mMSServer) {
        this.server = mMSServer;
    }

    void parseCommand(byte[] byArray) {
        this.mms.parseCommand(byArray);
        this.commandValue = this.mms.getCommandValue();
        if (this.commandValue == 1) {
            this.parse01(byArray);
        } else if (this.commandValue == 24) {
            this.parse18(byArray);
        } else if (this.commandValue == 2) {
            this.parse02(byArray);
        } else if (this.commandValue == 5) {
            this.parse05(byArray);
        } else if (this.commandValue == 21) {
            this.parse15(byArray);
        } else if (this.commandValue == 51) {
            this.parse33(byArray);
        } else if (this.commandValue == 7) {
            this.parse07(byArray);
        } else if (this.commandValue == 27) {
            this.parse1B(byArray);
        } else if (this.commandValue == 50) {
            this.parse32(byArray);
        } else if (this.commandValue == 40) {
            this.parse28(byArray);
        }
    }

    void parse01(byte[] byArray) {
    }

    void parse18(byte[] byArray) {
    }

    void parse02(byte[] byArray) {
        this.server.setPacketID(byArray[56] & 0xFF);
    }

    void parse05(byte[] byArray) {
    }

    void parse15(byte[] byArray) {
        this.server.setPacketID(byArray[80] & 0xFF);
    }

    void parse33(byte[] byArray) {
    }

    void parse07(byte[] byArray) {
        long l = 0L;
        for (int i = 55; i >= 48; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        double d = Double.longBitsToDouble(l);
        if (d > 1.0E308) {
            this.server.setPauseState(true);
        } else {
            this.server.setSeekPoint(d);
        }
        this.server.setPacketID(byArray[68] & 0xFF);
    }

    void parse1B(byte[] byArray) {
    }

    void parse32(byte[] byArray) {
    }

    void parse28(byte[] byArray) {
        long l = 0L;
        for (int i = 55; i >= 48; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        double d = Double.longBitsToDouble(l);
        this.server.setSeekPoint(d);
        System.out.println("ffPoint : " + d);
        this.server.setPacketID(byArray[68] & 0xFF);
        for (int i = 79; i >= 72; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        double d2 = Double.longBitsToDouble(l);
        System.out.println("rwPoint : " + d2);
    }

    void printHexdump(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            string = string.length() == 1 ? '0' + string.toUpperCase() : string.toUpperCase();
            System.out.print(string + " ");
            if (++n <= 15) continue;
            System.out.println();
            n = 0;
        }
        System.out.println();
    }

    int getCommandValue() {
        return this.commandValue;
    }

    int getSequenceNumber() {
        return this.mms.getSequenceNumber();
    }
}

