/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import java.io.UnsupportedEncodingException;

class ContentDescription
extends AsfHeaderObject {
    private int objectSize;
    private int titleLength;
    private int authorLength;
    private int copyrightLength;
    private int descriptionLength;
    private int ratingLength;
    private String title;
    private String author;
    private String copyright;
    private String description;
    private String rating;
    private String nullString;

    public ContentDescription(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.titleLength = (byArray[n + 24] & 0xFF) + ((byArray[n + 25] & 0xFF) << 8);
        this.authorLength = (byArray[n + 26] & 0xFF) + ((byArray[n + 27] & 0xFF) << 8);
        this.copyrightLength = (byArray[n + 28] & 0xFF) + ((byArray[n + 29] & 0xFF) << 8);
        this.descriptionLength = (byArray[n + 30] & 0xFF) + ((byArray[n + 31] & 0xFF) << 8);
        this.ratingLength = (byArray[n + 32] & 0xFF) + ((byArray[n + 33] & 0xFF) << 8);
        try {
            byte[] byArray2 = new byte[this.titleLength];
            System.arraycopy(byArray, n + 34, byArray2, 0, this.titleLength);
            this.title = new String(byArray2, "UTF-16LE");
            byte[] byArray3 = new byte[this.authorLength];
            System.arraycopy(byArray, n + 34 + this.titleLength, byArray3, 0, this.authorLength);
            this.author = new String(byArray3, "UTF-16LE");
            byte[] byArray4 = new byte[this.copyrightLength];
            System.arraycopy(byArray, n + 34 + this.titleLength + this.authorLength, byArray4, 0, this.copyrightLength);
            this.copyright = new String(byArray4, "UTF-16LE");
            byte[] byArray5 = new byte[this.descriptionLength];
            System.arraycopy(byArray, n + 34 + this.titleLength + this.authorLength + this.copyrightLength, byArray5, 0, this.descriptionLength);
            this.description = new String(byArray5, "UTF-16LE");
            byte[] byArray6 = new byte[this.ratingLength];
            System.arraycopy(byArray, n + 34 + this.titleLength + this.authorLength + this.copyrightLength + this.descriptionLength, byArray6, 0, this.ratingLength);
            this.rating = new String(byArray6, "UTF-16LE");
            byte[] byArray7 = new byte[]{0, 0};
            this.nullString = new String(byArray7, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Content_Description_Object, 0, byArray, 0, 16);
        for (n = 0; n < 4; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[20 + n] = 0;
        }
        byArray[24] = (byte)this.titleLength;
        byArray[25] = (byte)(this.titleLength >> 8);
        byArray[26] = (byte)this.authorLength;
        byArray[27] = (byte)(this.authorLength >> 8);
        byArray[28] = (byte)this.copyrightLength;
        byArray[29] = (byte)(this.copyrightLength >> 8);
        byArray[30] = (byte)this.descriptionLength;
        byArray[31] = (byte)(this.descriptionLength >> 8);
        byArray[32] = (byte)this.ratingLength;
        byArray[33] = (byte)(this.ratingLength >> 8);
        try {
            byte[] byArray2 = this.title.getBytes("UTF-16LE");
            System.arraycopy(byArray2, 0, byArray, 34, this.titleLength);
            byte[] byArray3 = this.author.getBytes("UTF-16LE");
            System.arraycopy(byArray3, 0, byArray, 34 + this.titleLength, this.authorLength);
            byte[] byArray4 = this.copyright.getBytes("UTF-16LE");
            System.arraycopy(byArray4, 0, byArray, 34 + this.titleLength + this.authorLength, this.copyrightLength);
            byte[] byArray5 = this.description.getBytes("UTF-16LE");
            System.arraycopy(byArray5, 0, byArray, 34 + this.titleLength + this.authorLength + this.copyrightLength, this.descriptionLength);
            byte[] byArray6 = this.rating.getBytes("UTF-16LE");
            System.arraycopy(byArray6, 0, byArray, 34 + this.titleLength + this.authorLength + this.copyrightLength + this.descriptionLength, this.ratingLength);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Content_Description_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 2);
        stringBuffer.append("\t Title Length : " + this.titleLength + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 26, 2);
        stringBuffer.append("\t Author Length : " + this.authorLength + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 28, 2);
        stringBuffer.append("\t Copyright Length : " + this.copyrightLength + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 30, 2);
        stringBuffer.append("\t Description Length : " + this.descriptionLength + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 32, 2);
        stringBuffer.append("\t Rating Length : " + this.ratingLength + "\n");
        int n = 0;
        AsfHeader.appendHexString(stringBuffer, byArray, 34 + n, this.titleLength);
        stringBuffer.append("\t Title : " + this.title + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 34 + (n += this.titleLength), this.authorLength);
        stringBuffer.append("\t Author : " + this.author + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 34 + (n += this.authorLength), this.copyrightLength);
        stringBuffer.append("\t Copyright : " + this.copyright + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 34 + (n += this.copyrightLength), this.descriptionLength);
        stringBuffer.append("\t Description : " + this.description + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 34 + (n += this.descriptionLength), this.ratingLength);
        stringBuffer.append("\t Rating : " + this.rating + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    int getObjectSize() {
        return this.objectSize;
    }

    String getTitle() {
        if (this.titleLength > 0 && this.title.substring(this.title.length() - 1).equals(this.nullString)) {
            String string = this.title.substring(0, this.title.length() - 1);
            return string;
        }
        System.out.println("getTitle()" + this.title);
        return "";
    }

    String getAuthor() {
        if (this.authorLength > 0 && this.author.substring(this.author.length() - 1).equals(this.nullString)) {
            String string = this.author.substring(0, this.author.length() - 1);
            return string;
        }
        return "";
    }

    String getCopyright() {
        if (this.copyrightLength > 0 && this.copyright.substring(this.copyright.length() - 1).equals(this.nullString)) {
            String string = this.copyright.substring(0, this.copyright.length() - 1);
            return string;
        }
        return "";
    }

    String getDescription() {
        if (this.descriptionLength > 0 && this.description.substring(this.description.length() - 1).equals(this.nullString)) {
            String string = this.description.substring(0, this.description.length() - 1);
            return string;
        }
        return "";
    }

    String getRating() {
        if (this.ratingLength > 0 && this.rating.substring(this.rating.length() - 1).equals(this.nullString)) {
            String string = this.rating.substring(0, this.rating.length() - 1);
            return string;
        }
        return "";
    }

    void setTitle(String string) {
        if (this.titleLength != 0 || string.length() != 0) {
            this.title = string + this.nullString;
            this.titleLength = this.title.length() * 2;
            this.updateObjectSize();
        }
    }

    public void setAuthor(String string) {
        if (this.authorLength != 0 || string.length() != 0) {
            this.author = string + this.nullString;
            this.authorLength = this.author.length() * 2;
            this.updateObjectSize();
        }
    }

    public void setCopyright(String string) {
        if (this.copyrightLength != 0 || string.length() != 0) {
            this.copyright = string + this.nullString;
            this.copyrightLength = this.copyright.length() * 2;
            this.updateObjectSize();
        }
    }

    public void setDescription(String string) {
        if (this.descriptionLength != 0 || string.length() != 0) {
            this.description = string + this.nullString;
            this.descriptionLength = this.description.length() * 2;
            this.updateObjectSize();
        }
    }

    public void setRating(String string) {
        if (this.ratingLength != 0 || string.length() != 0) {
            this.rating = string + this.nullString;
            this.ratingLength = this.rating.length() * 2;
            this.updateObjectSize();
        }
    }

    void updateObjectSize() {
        this.objectSize = 34 + this.titleLength + this.authorLength + this.copyrightLength + this.descriptionLength + this.ratingLength;
    }
}

