/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;

class ErrorCorrectionData {
    int objectSize;
    int span;
    int virtualPacketLength;
    int virtualChunkLength;
    int silenceDataLength;
    byte[] silenceData;

    public ErrorCorrectionData() {
        this.objectSize = 8;
        this.span = 1;
        this.virtualPacketLength = 960;
        this.virtualChunkLength = 960;
        this.silenceDataLength = 1;
        this.silenceData = new byte[1];
        this.silenceData[0] = 0;
    }

    public ErrorCorrectionData(byte[] byArray, int n, int n2) {
        this.objectSize = n2;
        this.span = byArray[n] & 0xFF;
        this.virtualPacketLength = byArray[n + 1] & 255 + ((byArray[n + 2] & 0xFF) << 8);
        this.virtualChunkLength = byArray[n + 3] & 255 + ((byArray[n + 4] & 0xFF) << 8);
        this.silenceDataLength = byArray[n + 5] & 255 + ((byArray[n + 6] & 0xFF) << 8);
        this.silenceData = new byte[this.silenceDataLength];
        System.arraycopy(byArray, n + 7, this.silenceData, 0, this.silenceDataLength);
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        byArray[0] = (byte)this.span;
        byArray[1] = (byte)this.virtualPacketLength;
        byArray[2] = (byte)(this.virtualPacketLength >> 8);
        byArray[3] = (byte)this.virtualChunkLength;
        byArray[4] = (byte)(this.virtualChunkLength >> 8);
        byArray[5] = (byte)this.silenceDataLength;
        byArray[6] = (byte)(this.silenceDataLength >> 8);
        for (int i = 0; i < this.objectSize - 7; ++i) {
            byArray[this.objectSize - 1] = this.silenceData[i];
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 1);
        stringBuffer.append("\t span\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 1, 2);
        stringBuffer.append("\t virtualPacketLength : " + this.virtualPacketLength + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 3, 2);
        stringBuffer.append("\t virtualChunkLength : " + this.virtualChunkLength + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 5, 2);
        stringBuffer.append("\t silenceDataLength : " + this.silenceDataLength + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 7, this.objectSize - 7);
        stringBuffer.append("\t silenceData\n");
        return stringBuffer.toString();
    }
}

