/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import java.io.UnsupportedEncodingException;

class ExtendedContentDescription
extends AsfHeaderObject {
    private int objectSize;
    private int contentDescriptorsCounts;
    private int[] descriptorsNameLength;
    private byte[][] descriptorName;
    private int[] descriptorValueDataType;
    private int[] descriptorValueLength;
    private byte[][] descriptorValue;

    public ExtendedContentDescription(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.contentDescriptorsCounts = (byArray[n + 24] & 0xFF) + ((byArray[n + 25] & 0xFF) << 8);
        this.descriptorsNameLength = new int[this.contentDescriptorsCounts];
        this.descriptorName = new byte[this.contentDescriptorsCounts][];
        this.descriptorValueDataType = new int[this.contentDescriptorsCounts];
        this.descriptorValueLength = new int[this.contentDescriptorsCounts];
        this.descriptorValue = new byte[this.contentDescriptorsCounts][];
        int n2 = n + 26;
        for (int i = 0; i < this.contentDescriptorsCounts; ++i) {
            this.descriptorsNameLength[i] = (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
            this.descriptorName[i] = new byte[this.descriptorsNameLength[i]];
            System.arraycopy(byArray, n2 + 2, this.descriptorName[i], 0, this.descriptorsNameLength[i]);
            this.descriptorValueDataType[i] = (byArray[n2 += 2 + this.descriptorsNameLength[i]] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
            this.descriptorValueLength[i] = (byArray[n2 + 2] & 0xFF) + ((byArray[n2 + 3] & 0xFF) << 8);
            this.descriptorValue[i] = new byte[this.descriptorValueLength[i]];
            System.arraycopy(byArray, n2 + 4, this.descriptorValue[i], 0, this.descriptorValueLength[i]);
            n2 += 4 + this.descriptorValueLength[i];
        }
    }

    int getObjectSize() {
        return this.objectSize;
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Extended_Content_Description_Object, 0, byArray, 0, 16);
        for (n = 0; n < 4; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[20 + n] = 0;
        }
        byArray[24] = (byte)this.contentDescriptorsCounts;
        byArray[25] = (byte)(this.contentDescriptorsCounts >> 8);
        n = 25;
        for (int i = 0; i < this.contentDescriptorsCounts; ++i) {
            byArray[n] = (byte)this.descriptorsNameLength[i];
            byArray[n + 1] = (byte)(this.descriptorsNameLength[i] >> 8);
            System.arraycopy(this.descriptorName[i], 0, byArray, n + 2, this.descriptorsNameLength[i]);
            byArray[n += this.descriptorsNameLength[i] + 2] = (byte)this.descriptorValueDataType[i];
            byArray[n + 1] = (byte)(this.descriptorValueDataType[i] >> 8);
            byArray[n + 2] = (byte)this.descriptorValueLength[i];
            byArray[n + 3] = (byte)(this.descriptorValueLength[i] >> 8);
            System.arraycopy(this.descriptorValue[i], 0, byArray, n + 4, this.descriptorValueLength[i]);
            n += this.descriptorValueLength[i] + 4;
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Extended_Content_Description_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t\t\t objectSize : " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 2);
        stringBuffer.append("\t\t\t\t contentDescriptorsCounts : " + this.contentDescriptorsCounts + "\n");
        try {
            int n = 25;
            for (int i = 0; i < this.contentDescriptorsCounts; ++i) {
                AsfHeader.appendHexString(stringBuffer, byArray, n, 2);
                stringBuffer.append("\t\t\t\t Descriptors Name Length : " + this.descriptorsNameLength[i] + " bytes\n");
                AsfHeader.appendHexString(stringBuffer, byArray, n + 2, this.descriptorsNameLength[i]);
                String string = new String(this.descriptorName[i], "UTF-16LE");
                stringBuffer.append("\t\t Descriptor Name : " + string + "\n");
                AsfHeader.appendHexString(stringBuffer, byArray, n += this.descriptorsNameLength[i] + 2, 2);
                stringBuffer.append("\t\t\t\t Descriptors Value Data Type : " + this.decodeDescriptorType(this.descriptorValueDataType[i]) + "\n");
                AsfHeader.appendHexString(stringBuffer, byArray, n + 2, 2);
                stringBuffer.append("\t\t\t\t Descriptors Value Length : " + this.descriptorValueLength[i] + " bytes\n");
                AsfHeader.appendHexString(stringBuffer, byArray, n + 2, this.descriptorValueLength[i]);
                if (this.descriptorValueDataType[i] == 0) {
                    String string2 = new String(this.descriptorValue[i], "UTF-16LE");
                    stringBuffer.append("\t\t\t Descriptor Value : " + string2 + "\n\n");
                } else {
                    stringBuffer.append("\t\t\t Descriptor Value\n\n");
                }
                n += this.descriptorValueLength[i] + 4;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    private String decodeDescriptorType(int n) {
        if (n == 0) {
            return "Unicode string";
        }
        if (n == 1) {
            return "Byte array";
        }
        if (n == 2) {
            return "Bool";
        }
        if (n == 3) {
            return "DWORD";
        }
        if (n == 4) {
            return "QWORD";
        }
        if (n == 5) {
            return "WORD";
        }
        return "Unknown";
    }
}

