/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;

class FileProperties
extends AsfHeaderObject {
    private int objectSize;
    private byte[] fileID;
    private long fileSize;
    private long creationDate;
    private int packetsCount;
    private long playDuration;
    private long sendDuration;
    private int preroll;
    private boolean broadcast;
    private boolean seekable;
    private int minimumDataPacketSize;
    private int maximumDataPacketSize;
    private int maximumBitrate;

    public FileProperties() {
        this.objectSize = 104;
    }

    public FileProperties(byte[] byArray, int n) {
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.fileID = new byte[16];
        System.arraycopy(byArray, n + 24, this.fileID, 0, 16);
        this.fileSize = ((long)byArray[n + 40] & 0xFFL) + ((long)(byArray[n + 41] & 0xFF) << 8) + ((long)(byArray[n + 42] & 0xFF) << 16) + ((long)(byArray[n + 43] & 0xFF) << 24) + ((long)(byArray[n + 44] & 0xFF) << 32) + ((long)(byArray[n + 45] & 0xFF) << 40) + ((long)(byArray[n + 46] & 0xFF) << 48) + ((long)(byArray[n + 47] & 0xFF) << 56);
        this.creationDate = (long)(byArray[n + 48] & 0xFF) + ((long)(byArray[n + 49] & 0xFF) << 8) + ((long)(byArray[n + 50] & 0xFF) << 16) + ((long)(byArray[n + 51] & 0xFF) << 24) + ((long)(byArray[n + 52] & 0xFF) << 32) + ((long)(byArray[n + 53] & 0xFF) << 40) + ((long)(byArray[n + 54] & 0xFF) << 48) + ((long)(byArray[n + 55] & 0xFF) << 56);
        this.packetsCount = (byArray[n + 56] & 0xFF) + ((byArray[n + 57] & 0xFF) << 8) + ((byArray[n + 58] & 0xFF) << 16) + ((byArray[n + 59] & 0xFF) << 24);
        this.playDuration = (long)(byArray[n + 64] & 0xFF) + ((long)(byArray[n + 65] & 0xFF) << 8) + ((long)(byArray[n + 66] & 0xFF) << 16) + ((long)(byArray[n + 67] & 0xFF) << 24) + ((long)(byArray[n + 68] & 0xFF) << 32) + ((long)(byArray[n + 69] & 0xFF) << 40) + ((long)(byArray[n + 70] & 0xFF) << 48) + ((long)(byArray[n + 71] & 0xFF) << 56);
        this.sendDuration = (long)(byArray[n + 72] & 0xFF) + ((long)(byArray[n + 73] & 0xFF) << 8) + ((long)(byArray[n + 74] & 0xFF) << 16) + ((long)(byArray[n + 75] & 0xFF) << 24) + ((long)(byArray[n + 76] & 0xFF) << 32) + ((long)(byArray[n + 77] & 0xFF) << 40) + ((long)(byArray[n + 78] & 0xFF) << 48) + ((long)(byArray[n + 79] & 0xFF) << 56);
        this.preroll = (byArray[n + 80] & 0xFF) + ((byArray[n + 81] & 0xFF) << 8) + ((byArray[n + 82] & 0xFF) << 16) + ((byArray[n + 83] & 0xFF) << 24);
        if ((byArray[n + 88] & 1) == 1) {
            this.broadcast = true;
        }
        if ((byArray[n + 88] & 2) == 2) {
            this.seekable = true;
        }
        this.minimumDataPacketSize = (byArray[n + 92] & 0xFF) + ((byArray[n + 93] & 0xFF) << 8) + ((byArray[n + 94] & 0xFF) << 16) + ((byArray[n + 95] & 0xFF) << 24);
        this.maximumDataPacketSize = (byArray[n + 96] & 0xFF) + ((byArray[n + 97] & 0xFF) << 8) + ((byArray[n + 98] & 0xFF) << 16) + ((byArray[n + 99] & 0xFF) << 24);
        this.maximumBitrate = (byArray[n + 100] & 0xFF) + ((byArray[n + 101] & 0xFF) << 8) + ((byArray[n + 102] & 0xFF) << 16) + ((byArray[n + 103] & 0xFF) << 24);
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_File_Properties_Object, 0, byArray, 0, 16);
        for (n = 0; n < 4; ++n) {
            byArray[16 + n] = (byte)(this.objectSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[20 + n] = 0;
        }
        System.arraycopy(this.fileID, 0, byArray, 24, 16);
        for (n = 0; n < 4; ++n) {
            byArray[40 + n] = (byte)(this.fileSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[44 + n] = 0;
        }
        for (n = 0; n < 8; ++n) {
            byArray[48 + n] = (byte)(this.creationDate >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[56 + n] = (byte)(this.packetsCount >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[60 + n] = 0;
        }
        for (n = 0; n < 8; ++n) {
            byArray[64 + n] = (byte)(this.playDuration >> 8 * n);
        }
        for (n = 0; n < 8; ++n) {
            byArray[72 + n] = (byte)(this.sendDuration >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[80 + n] = (byte)(this.preroll >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[84 + n] = 0;
        }
        if (!this.broadcast && this.seekable) {
            byArray[88] = 2;
        }
        for (n = 0; n < 3; ++n) {
            byArray[89 + n] = 0;
        }
        for (n = 0; n < 4; ++n) {
            byArray[92 + n] = (byte)(this.minimumDataPacketSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[96 + n] = (byte)(this.maximumDataPacketSize >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[100 + n] = (byte)(this.maximumBitrate >> 8 * n);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_File_Properties_Object GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 16);
        stringBuffer.append("\t File ID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 40, 8);
        stringBuffer.append("\t File Size : " + this.fileSize + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 48, 8);
        stringBuffer.append("\t Creation Date\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 56, 8);
        stringBuffer.append("\t Packets Count : " + this.packetsCount + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 64, 8);
        stringBuffer.append("\t Play Duration : " + this.playDuration + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 72, 8);
        stringBuffer.append("\t Send Duration : " + this.sendDuration + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 80, 8);
        stringBuffer.append("\t Preroll : " + this.preroll + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 88, 4);
        stringBuffer.append("\t Broadcast Flag : " + this.broadcast + "\t Seekable Flag : " + this.seekable + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 92, 4);
        stringBuffer.append("\t Minimum Data Packet Size : " + this.minimumDataPacketSize + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 96, 4);
        stringBuffer.append("\t Maximum Data Packet Size : " + this.maximumDataPacketSize + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 100, 4);
        stringBuffer.append("\t Maximum Bitrate : " + this.maximumBitrate + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    int getObjectSize() {
        return this.objectSize;
    }

    byte[] getFileID() {
        return this.fileID;
    }

    String getFileIDString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            n = this.fileID[i] & 0xFF;
            if (n <= 15) {
                stringBuffer.append("0" + Integer.toHexString(n));
            } else {
                stringBuffer.append(Integer.toHexString(n));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().toUpperCase();
    }

    long getFileSize() {
        return this.fileSize;
    }

    long getCreationDate() {
        return this.creationDate;
    }

    int getPacketsCount() {
        return this.packetsCount;
    }

    long getPlayDuration() {
        return this.playDuration;
    }

    long getSendDuration() {
        return this.sendDuration;
    }

    int getPreroll() {
        return this.preroll;
    }

    boolean isBroadcast() {
        return this.broadcast;
    }

    boolean isSeekable() {
        return this.seekable;
    }

    int getMinimumDataPacketSize() {
        return this.minimumDataPacketSize;
    }

    int getMaximumDataPacketSize() {
        return this.maximumDataPacketSize;
    }

    int getMaximumBitrate() {
        return this.maximumBitrate;
    }

    void setFileID(byte[] byArray) {
        this.fileID = byArray;
    }

    void setFileSize(long l) {
        this.fileSize = l;
    }

    void setCreationDate(long l) {
        this.creationDate = l;
    }

    void setTotalPacketsCount(int n) {
        this.packetsCount = n;
    }

    void setPlayDuration(long l) {
        this.playDuration = l;
    }

    void setSendDuration(long l) {
        this.sendDuration = l;
    }

    void setPreroll(int n) {
        this.preroll = n;
    }

    void setBroadcast(boolean bl) {
        this.broadcast = bl;
    }

    void setSeekable(boolean bl) {
        this.seekable = bl;
    }

    void setMinimumDataPacketSize(int n) {
        this.minimumDataPacketSize = n;
    }

    void setMaximumDataPacketSize(int n) {
        this.maximumDataPacketSize = n;
    }

    void setMaximumBitrate(int n) {
        this.maximumBitrate = n;
    }
}

