/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfCallback;
import asf.AsfFile;
import asf.ClientCommandParser;
import asf.MediaPacket;
import asf.MediaPlayer;
import asf.ServerCommandFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class MMSServer
implements Runnable {
    private BufferedInputStream bis;
    private OutputStream os;
    private BufferedOutputStream bos;
    private ServerSocket ss;
    private Socket sock;
    private ServerCommandFactory scf;
    private ClientCommandParser clientParser;
    private int sequenceNumber;
    private int portNum;
    private AsfFile asfFile;
    private MediaPacket mp;
    private Thread thread;
    private boolean serverStarted;
    private boolean stopServer;
    private byte[] preHeader = new byte[8];
    private int packetID;
    private int tcpFlag = 12;
    private MediaPlayer mediaPlayer;
    private double seekPoint;
    private long preroll;
    private boolean isPauseState;
    private int dataAddition;
    private long previousBaseTime;
    private AsfCallback callback;

    public MMSServer(int n) {
        this.portNum = n;
        this.clientParser = new ClientCommandParser(this);
        this.scf = new ServerCommandFactory(this);
    }

    public void setAsfFile(AsfFile asfFile) {
        this.asfFile = asfFile;
        this.scf.setAsfFile(asfFile);
        this.mp = asfFile.getMediaPacket();
    }

    public void setCallBack(AsfCallback asfCallback) {
        this.callback = asfCallback;
    }

    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    public void prepareServer() {
        try {
            this.ss = new ServerSocket(this.portNum);
            this.serverStarted = true;
        }
        catch (IOException iOException) {
            System.out.println("IOException at prepareServer : " + iOException);
        }
    }

    public void waitForConnection() {
        try {
            this.sock = this.ss.accept();
            InputStream inputStream = this.sock.getInputStream();
            this.bis = new BufferedInputStream(inputStream);
            this.os = this.sock.getOutputStream();
            this.bos = new BufferedOutputStream(this.os);
        }
        catch (IOException iOException) {
            System.out.println("IOException at prepareServer : " + iOException);
        }
    }

    public boolean isServerStarted() {
        return this.serverStarted;
    }

    public void listenForConnection() {
        this.stopServer = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopServer(boolean bl) {
        this.stopServer = bl;
    }

    public void run() {
        this.asfFile.prepareData();
        this.waitForConnection();
        this.startSession();
        this.sendMediaPackets();
    }

    void sendByteArray(byte[] byArray) {
        try {
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            System.out.println("IOException at  sendByteArray( byte[]  b ) : " + iOException);
        }
    }

    private void sendByteArray(byte[] byArray, int n, int n2) {
        try {
            this.bos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            System.out.println("IOException at sendByteArray( byte[]  b,  int  off,  int  len ) : " + iOException);
        }
    }

    private void flushOutput() {
        try {
            this.bos.flush();
        }
        catch (IOException iOException) {
            System.out.println("IOException at flushOutput : " + iOException);
        }
    }

    public void closeSession() {
        try {
            this.stopServer = true;
            if (this.bos != null) {
                this.bos.close();
            }
            this.bos = null;
            if (this.bis != null) {
                this.bis.close();
            }
            this.bis = null;
            if (this.sock != null && this.sock.isConnected()) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException at closeSession : " + iOException);
        }
    }

    private void startSession() {
        this.sequenceNumber = 0;
        while (!this.stopServer) {
            int n = this.recieveCommand();
            if (n == 1) {
                this.sendByteArray(this.scf.createCommand(1, this.sequenceNumber));
                this.flushOutput();
            } else if (n == 24) {
                this.sendByteArray(this.scf.createCommand(21, this.sequenceNumber));
                this.flushOutput();
            } else if (n == 2) {
                this.sendByteArray(this.scf.createCommand(2, this.sequenceNumber));
                this.flushOutput();
            } else if (n == 5) {
                this.sendByteArray(this.scf.createCommand(6, this.sequenceNumber));
                this.flushOutput();
            } else if (n == 21) {
                this.tcpFlag = 12;
                this.sendByteArray(this.scf.createCommand(17, this.sequenceNumber));
                this.sendByteArray(this.generatePreHeader(0L, this.asfFile.getHeaderLength() + 50));
                this.sendByteArray(this.asfFile.getHeaderByteArray());
                this.sendByteArray(this.asfFile.getDataHeaderByteArray());
                this.flushOutput();
            } else if (n == 51) {
                this.sendByteArray(this.scf.createCommand(33, this.sequenceNumber));
                this.flushOutput();
            } else if (n == 7) {
                this.sendByteArray(this.scf.createCommand(5, this.sequenceNumber));
                this.flushOutput();
                break;
            }
            ++this.sequenceNumber;
        }
    }

    private void startMediaPlayer() {
        this.mediaPlayer.start();
    }

    private void setTimeToMediaPlayer(double d) {
        this.mediaPlayer.setTime(d);
    }

    private void stopMediaPlayer() {
        this.mediaPlayer.stop();
    }

    private double getTimeFromMediaPlayer() {
        return this.mediaPlayer.getTime();
    }

    private void sendMediaPackets() {
        byte[] byArray = null;
        int n = 0;
        long l = 0L;
        int n2 = this.asfFile.getTotalPacketsCount();
        long l2 = 0L;
        boolean bl = false;
        int n3 = 50;
        boolean bl2 = false;
        this.preroll = this.asfFile.getPreroll();
        boolean bl3 = true;
        long l3 = System.currentTimeMillis();
        long l4 = System.currentTimeMillis();
        long l5 = 0L;
        long l6 = 3000L;
        this.tcpFlag = 4;
        while (!this.stopServer) {
            if (this.asfFile.readNextPacketRA() != -1) {
                byArray = this.mp.getPacketBuffer();
                n = byArray.length - this.mp.getPaddingLength();
                this.sendByteArray(this.generatePreHeader(l, n));
                this.sendByteArray(byArray, 0, n);
                this.flushOutput();
                if (++l == 1L) {
                    this.tcpFlag = 0;
                } else if (l == (long)(n2 - 1)) {
                    this.tcpFlag = 8;
                } else if (l == (long)n2) {
                    bl2 = true;
                }
            }
            if (this.recieveAvailable()) {
                int n4 = this.recieveCommand();
                if (n4 == 9) {
                    bl2 = true;
                    this.stopMediaPlayer();
                }
                if (bl && n4 == 27) {
                    bl = false;
                }
            }
            if (bl) {
                if (n3 == 0) break;
                if (n3 > 0) {
                    --n3;
                }
            }
            if (l2 > 60000L) {
                this.sendByteArray(this.scf.createCommand(27, this.sequenceNumber));
                l2 = 0L;
                bl = true;
                n3 = 50;
            }
            if (bl3 && System.currentTimeMillis() - l4 > 1000L) {
                this.startMediaPlayer();
                bl3 = false;
            }
            if ((l5 = this.mp.getSendTime() + l3 - System.currentTimeMillis() - this.preroll - l6) > 0L) {
                this.sleepThread(l5);
                l2 += l5;
            }
            if (!bl2) continue;
            this.sendByteArray(this.scf.createCommand(30, this.sequenceNumber));
            this.flushOutput();
            this.waitCommand();
            this.stopMediaPlayer();
            bl2 = false;
            l2 = 0L;
            if (this.isPauseState) {
                this.isPauseState = false;
                this.startMediaPlayer();
                bl3 = false;
            } else {
                l = this.getCorrespondingPacket(this.seekPoint);
                this.setTimeToMediaPlayer(this.seekPoint);
                this.tcpFlag = 4;
                bl3 = true;
            }
            l3 = System.currentTimeMillis() - this.mp.getSendTime();
            l4 = System.currentTimeMillis();
        }
        this.closeSession();
    }

    private int getCorrespondingPacket(double d) {
        long l = this.asfFile.getPlayDuration();
        long l2 = this.asfFile.getTotalPacketsCount();
        long l3 = (long)(d * 1.0E7);
        int n = (int)(l3 * l2 / l);
        long l4 = (long)(d * 1000.0);
        long l5 = 0L;
        while (true) {
            this.asfFile.seekPacket(n);
            this.asfFile.readNextPacketRA();
            l5 = l4 - this.mp.getFirstPresentationTime();
            if (l5 > 0L) break;
            if (l5 >= 0L) continue;
            if (n < 20) {
                n = 0;
                this.asfFile.seekPacket(n);
                break;
            }
            n -= 20;
        }
        do {
            this.asfFile.readNextPacketRA();
        } while ((l5 = l4 - this.mp.getFirstPresentationTime()) >= 0L);
        n = this.asfFile.getPacketCount();
        this.preroll = this.mp.getFirstPresentationTime() - this.mp.getSendTime();
        return n;
    }

    private void waitCommand() {
        this.sequenceNumber = 0;
        int n = 0;
        while (!this.stopServer) {
            if (this.recieveAvailable()) {
                n = this.recieveCommand();
            }
            if (n == 51) {
                this.sendByteArray(this.scf.createCommand(33, this.sequenceNumber));
                this.flushOutput();
            } else {
                if (n == 7) {
                    this.sendByteArray(this.scf.createCommand(5, this.sequenceNumber));
                    this.flushOutput();
                    break;
                }
                if (n == 40) {
                    this.sendByteArray(this.scf.createCommand(10, this.sequenceNumber));
                    this.flushOutput();
                    this.tcpFlag = 4;
                    break;
                }
            }
            this.sleepThread(100L);
        }
    }

    private void calcDataRate(int n, long l) {
        this.dataAddition += n;
        long l2 = l - this.previousBaseTime;
        if (l2 >= 1000L) {
            this.callback.setDataRate((int)((long)(1000 * this.dataAddition) / l2));
            this.previousBaseTime = l;
            this.dataAddition = 0;
        }
    }

    private byte[] generatePreHeader(long l, int n) {
        this.preHeader[0] = (byte)l;
        this.preHeader[1] = (byte)(l >> 8);
        this.preHeader[2] = (byte)(l >> 16);
        this.preHeader[3] = (byte)(l >> 24);
        this.preHeader[4] = (byte)this.packetID;
        this.preHeader[5] = (byte)this.tcpFlag;
        if (this.tcpFlag == 8) {
            // empty if block
        }
        int n2 = 8 + n;
        this.preHeader[6] = (byte)n2;
        this.preHeader[7] = (byte)(n2 >> 8);
        return this.preHeader;
    }

    private boolean recieveAvailable() {
        int n = 0;
        try {
            n = this.bis.available();
        }
        catch (IOException iOException) {
            System.out.println("IOException at recieveAvailable : " + iOException);
        }
        return n > 0;
    }

    private int recieveCommand() {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[16];
        try {
            while (n == 0) {
                n = this.bis.available();
            }
            this.bis.read(byArray);
            int n3 = (byArray[8] & 0xFF) + ((byArray[9] & 0xFF) << 8) + ((byArray[10] & 0xFF) << 16) + ((byArray[11] & 0xFF) << 24);
            byte[] byArray2 = new byte[n3 + 16];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            this.bis.read(byArray2, 16, n3);
            this.clientParser.parseCommand(byArray2);
            n2 = this.clientParser.getCommandValue();
        }
        catch (IOException iOException) {
            System.out.println("IOException at recieveCommand : " + iOException);
        }
        return n2;
    }

    int getPacketID() {
        return this.packetID;
    }

    void setPacketID(int n) {
        this.packetID = n;
    }

    void setSeekPoint(double d) {
        this.seekPoint = d;
    }

    void setPauseState(boolean bl) {
        this.isPauseState = bl;
    }

    private void sleepThread(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException at sendMediaPackets : " + interruptedException);
        }
    }

    private void printHexdump(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            string = string.length() == 1 ? '0' + string.toUpperCase() : string.toUpperCase();
            System.out.print(string + " ");
            if (++n <= 15) continue;
            System.out.println();
            n = 0;
        }
        System.out.println();
        System.out.println();
    }
}

