/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import java.util.ArrayList;

class SimpleIndex
implements AsfConstants {
    byte[] b;
    int objectSize;
    byte[] fileID;
    long interval;
    int maximumPacketCount;
    int indexEntriesCount;
    int[][] indexEntries;
    ArrayList simpleList;

    public SimpleIndex() {
    }

    public SimpleIndex(ArrayList arrayList) {
        this.simpleList = arrayList;
    }

    public SimpleIndex(byte[] byArray) {
        this.b = byArray;
        if (!this.checkGUID(0, AsfConstants.ASF_Simple_Index_Object)) {
            System.out.println("This is not Simple Index GUID");
        } else {
            this.objectSize = (byArray[16] & 0xFF) + ((byArray[17] & 0xFF) << 8) + ((byArray[18] & 0xFF) << 16) + ((byArray[19] & 0xFF) << 24);
            this.interval = (byArray[40] & 0xFF) + ((byArray[41] & 0xFF) << 8) + ((byArray[42] & 0xFF) << 16) + ((byArray[43] & 0xFF) << 24) + ((byArray[44] & 0xFF) << 32) + ((byArray[45] & 0xFF) << 40) + ((byArray[46] & 0xFF) << 48) + ((byArray[47] & 0xFF) << 56);
            this.maximumPacketCount = (byArray[48] & 0xFF) + ((byArray[49] & 0xFF) << 8) + ((byArray[50] & 0xFF) << 16) + ((byArray[51] & 0xFF) << 24);
            this.indexEntriesCount = (byArray[52] & 0xFF) + ((byArray[53] & 0xFF) << 8) + ((byArray[54] & 0xFF) << 16) + ((byArray[55] & 0xFF) << 24);
            this.indexEntries = new int[this.indexEntriesCount][2];
            int n = 0;
            int n2 = 0;
            while (n < this.indexEntriesCount) {
                this.indexEntries[n][0] = (byArray[56 + n2] & 0xFF) + ((byArray[57 + n2] & 0xFF) << 8) + ((byArray[58 + n2] & 0xFF) << 16) + ((byArray[59 + n2] & 0xFF) << 24);
                this.indexEntries[n][1] = (byArray[60 + n2] & 0xFF) + ((byArray[61 + n2] & 0xFF) << 8);
                ++n;
                n2 += 6;
            }
        }
    }

    public void makeSimpleIndex(byte[] byArray) {
        this.objectSize = 62;
        this.fileID = byArray;
        this.interval = 10000000L;
        this.maximumPacketCount = 1;
        this.indexEntriesCount = 1;
        this.indexEntries = new int[this.indexEntriesCount][2];
        this.indexEntries[0][0] = 0;
        this.indexEntries[0][1] = 1;
    }

    public void makeSimpleIndex(byte[] byArray, int n) {
        int n2;
        this.fileID = byArray;
        this.interval = 10000000L;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n2 = 0; n2 < this.simpleList.size(); ++n2) {
            int[] nArray = (int[])this.simpleList.get(n2);
            int n8 = nArray[1];
            if (n2 == 0) {
                n4 = nArray[0];
                n5 = n8;
            }
            if (n8 != n5) {
                n3 = nArray[2];
                for (int i = 0; i < n3 - n6; ++i) {
                    int[] nArray2 = new int[]{n4, n7};
                    arrayList.add(nArray2);
                }
                n4 = nArray[0];
                n7 = 0;
            }
            ++n7;
            n5 = n8;
            n6 = n3;
        }
        for (n2 = 0; n2 < n - n6; ++n2) {
            int[] nArray = new int[]{n4, n7};
            arrayList.add(nArray);
        }
        this.indexEntriesCount = arrayList.size();
        this.indexEntries = new int[this.indexEntriesCount][2];
        for (n2 = 0; n2 < this.indexEntriesCount; ++n2) {
            int[] nArray = (int[])arrayList.get(n2);
            this.indexEntries[n2][0] = nArray[0];
            this.indexEntries[n2][1] = nArray[1];
            if (nArray[1] <= this.maximumPacketCount) continue;
            this.maximumPacketCount = nArray[1];
        }
        this.objectSize = 56 + this.indexEntriesCount * 6;
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Simple_Index_Object, 0, byArray, 0, 16);
        byArray[16] = (byte)this.objectSize;
        byArray[17] = (byte)(this.objectSize >> 8);
        byArray[18] = (byte)(this.objectSize >> 16);
        byArray[19] = (byte)(this.objectSize >> 24);
        System.arraycopy(this.fileID, 0, byArray, 24, 16);
        byArray[40] = (byte)this.interval;
        byArray[41] = (byte)(this.interval >> 8);
        byArray[42] = (byte)(this.interval >> 16);
        byArray[43] = (byte)(this.interval >> 24);
        byArray[44] = (byte)(this.interval >> 32);
        byArray[45] = (byte)(this.interval >> 40);
        byArray[46] = (byte)(this.interval >> 48);
        byArray[47] = (byte)(this.interval >> 56);
        byArray[48] = (byte)this.maximumPacketCount;
        byArray[49] = (byte)(this.maximumPacketCount >> 8);
        byArray[50] = (byte)(this.maximumPacketCount >> 16);
        byArray[51] = (byte)(this.maximumPacketCount >> 24);
        byArray[52] = (byte)this.indexEntriesCount;
        byArray[53] = (byte)(this.indexEntriesCount >> 8);
        byArray[54] = (byte)(this.indexEntriesCount >> 16);
        byArray[55] = (byte)(this.indexEntriesCount >> 24);
        int n = 0;
        int n2 = 0;
        while (n < this.indexEntriesCount) {
            byArray[56 + n2] = (byte)this.indexEntries[n][0];
            byArray[57 + n2] = (byte)(this.indexEntries[n][0] >> 8);
            byArray[58 + n2] = (byte)(this.indexEntries[n][0] >> 16);
            byArray[59 + n2] = (byte)(this.indexEntries[n][0] >> 24);
            byArray[60 + n2] = (byte)this.indexEntries[n][1];
            byArray[61 + n2] = (byte)(this.indexEntries[n][1] >> 8);
            ++n;
            n2 += 6;
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Simple_Index_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t objectSize : " + this.objectSize + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 16);
        stringBuffer.append("\t File ID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 40, 8);
        stringBuffer.append("\t interval : " + this.interval + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 48, 4);
        stringBuffer.append("\t interval : " + this.maximumPacketCount + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 52, 4);
        stringBuffer.append("\t interval : " + this.indexEntriesCount + "\n");
        int n = 0;
        int n2 = 0;
        while (n < this.indexEntriesCount) {
            AsfHeader.appendHexString(stringBuffer, byArray, 56 + n2, 6);
            stringBuffer.append("\t Packet Number : " + this.indexEntries[n][0] + "   ");
            stringBuffer.append(" Packet Count : " + this.indexEntries[n][1] + "\n");
            ++n;
            n2 += 6;
        }
        return stringBuffer.toString();
    }

    public int getObjectSize() {
        return this.objectSize;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getMaximumPacketCount() {
        return this.maximumPacketCount;
    }

    public int getIndexEntriesCount() {
        return this.indexEntriesCount;
    }

    public int[][] getIndexEntries() {
        return this.indexEntries;
    }

    boolean checkGUID(int n, byte[] byArray) {
        return this.b[n] == byArray[0] && this.b[n + 1] == byArray[1] && this.b[n + 2] == byArray[2] && this.b[n + 3] == byArray[3] && this.b[n + 4] == byArray[4] && this.b[n + 5] == byArray[5] && this.b[n + 6] == byArray[6] && this.b[n + 7] == byArray[7] && this.b[n + 8] == byArray[8] && this.b[n + 9] == byArray[9] && this.b[n + 10] == byArray[10] && this.b[n + 11] == byArray[11] && this.b[n + 12] == byArray[12] && this.b[n + 13] == byArray[13] && this.b[n + 14] == byArray[14] && this.b[n + 15] == byArray[15];
    }
}

