/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import asf.AsfStream;
import asf.BitmapInfoHeader;
import asf.ErrorCorrectionData;
import asf.TypeSpecificData;
import java.util.Arrays;

class StreamProperties
extends AsfHeaderObject
implements AsfConstants {
    private int objectSize;
    private byte[] streamTypeGUID = new byte[16];
    private byte[] errorCorrectionTypeGUID = new byte[16];
    private long timeOffset;
    private int typeSpecificDataLength;
    private int errorCorrectionDataLength;
    private int streamNumber;
    private boolean encrypted;
    private byte[] reserved = new byte[4];
    String streamType;
    TypeSpecificData typeSpecificData;
    ErrorCorrectionData errorCorrectionData;

    public StreamProperties(AsfStream asfStream) {
        int n = asfStream.getStreamType();
        String string = "";
        if (n == 2) {
            string = "audio";
            this.typeSpecificDataLength = 36;
            this.errorCorrectionDataLength = 8;
        } else if (n == 1) {
            string = "video";
            this.typeSpecificDataLength = 55;
            this.errorCorrectionDataLength = 0;
            this.objectSize = 133;
        }
        this.setStreamType(string);
        this.streamNumber = asfStream.getStreamNumber();
        this.typeSpecificData = new TypeSpecificData(asfStream, this.typeSpecificDataLength, string);
    }

    public StreamProperties(AsfHeader asfHeader, byte[] byArray, int n) {
        AsfStream asfStream = new AsfStream();
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        System.arraycopy(byArray, n + 24, this.streamTypeGUID, 0, 16);
        System.arraycopy(byArray, n + 40, this.errorCorrectionTypeGUID, 0, 16);
        if (Arrays.equals(this.streamTypeGUID, AsfConstants.ASF_Video_Media)) {
            this.streamType = "video";
            asfStream.setStreamType(1);
        } else if (Arrays.equals(this.streamTypeGUID, AsfConstants.ASF_Audio_Media)) {
            this.streamType = "audio";
            asfStream.setStreamType(2);
        }
        this.timeOffset = (byArray[n + 56] & 0xFF) + ((byArray[n + 57] & 0xFF) << 8) + ((byArray[n + 58] & 0xFF) << 16) + ((byArray[n + 59] & 0xFF) << 24) + ((byArray[n + 60] & 0xFF) << 32) + ((byArray[n + 61] & 0xFF) << 40) + ((byArray[n + 62] & 0xFF) << 48) + ((byArray[n + 63] & 0xFF) << 56);
        this.typeSpecificDataLength = (byArray[n + 64] & 0xFF) + ((byArray[n + 65] & 0xFF) << 8) + ((byArray[n + 66] & 0xFF) << 16) + ((byArray[n + 67] & 0xFF) << 24);
        this.errorCorrectionDataLength = (byArray[n + 68] & 0xFF) + ((byArray[n + 69] & 0xFF) << 8) + ((byArray[n + 70] & 0xFF) << 16) + ((byArray[n + 71] & 0xFF) << 24);
        this.streamNumber = byArray[n + 72] & 0x7F;
        asfStream.setStreamNumber(this.streamNumber);
        this.encrypted = (byArray[n + 73] & 1) == 1;
        System.arraycopy(byArray, n + 74, this.reserved, 0, 4);
        if (this.typeSpecificDataLength > 0) {
            if (this.streamType.equals("video")) {
                this.typeSpecificData = new TypeSpecificData(byArray, n + 78, this.typeSpecificDataLength, "video");
            } else if (this.streamType.equals("audio")) {
                this.typeSpecificData = new TypeSpecificData(byArray, n + 78, this.typeSpecificDataLength, "audio");
            }
        }
        if (this.errorCorrectionDataLength > 0 && !Arrays.equals(this.errorCorrectionTypeGUID, AsfConstants.ASF_No_Error_Correction) && Arrays.equals(this.errorCorrectionTypeGUID, AsfConstants.ASF_Audio_Spread)) {
            this.errorCorrectionData = new ErrorCorrectionData(byArray, n + 78 + this.typeSpecificDataLength, this.errorCorrectionDataLength);
        }
        asfHeader.addAsfStream(asfStream);
    }

    int getObjectSize() {
        return this.objectSize;
    }

    void setStreamType(String string) {
        this.streamType = string;
        if (string.equals("video")) {
            this.streamTypeGUID = AsfConstants.ASF_Video_Media;
            this.errorCorrectionTypeGUID = AsfConstants.ASF_No_Error_Correction;
        } else if (string.equals("audio")) {
            this.streamTypeGUID = AsfConstants.ASF_Audio_Media;
            this.errorCorrectionTypeGUID = AsfConstants.ASF_Audio_Spread;
        }
    }

    void setStreamNumber(int n) {
        this.streamNumber = n;
    }

    void setCodec(String string) {
    }

    void setBitmapInfoHeader(BitmapInfoHeader bitmapInfoHeader) {
        this.typeSpecificData.setBitmapInfoHeader(bitmapInfoHeader);
    }

    String getStreamType() {
        return this.streamType;
    }

    int getStreamNumber() {
        return this.streamNumber;
    }

    String getCodec() {
        return "";
    }

    byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.objectSize];
        System.arraycopy(AsfConstants.ASF_Stream_Properties_Object, 0, byArray, 0, 16);
        byArray[16] = (byte)this.objectSize;
        byArray[17] = (byte)(this.objectSize >> 8);
        byArray[18] = (byte)(this.objectSize >> 16);
        byArray[19] = (byte)(this.objectSize >> 24);
        byArray[20] = 0;
        byArray[21] = 0;
        byArray[22] = 0;
        byArray[23] = 0;
        System.arraycopy(this.streamTypeGUID, 0, byArray, 24, 16);
        System.arraycopy(this.errorCorrectionTypeGUID, 0, byArray, 40, 16);
        for (n = 0; n < 8; ++n) {
            byArray[56 + n] = (byte)(this.timeOffset >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[64 + n] = (byte)(this.typeSpecificDataLength >> 8 * n);
        }
        for (n = 0; n < 4; ++n) {
            byArray[68 + n] = (byte)(this.errorCorrectionDataLength >> 8 * n);
        }
        byArray[72] = (byte)this.streamNumber;
        byArray[73] = this.encrypted ? (byte)1 : 0;
        for (n = 0; n < 4; ++n) {
            byArray[74 + n] = this.reserved[n];
        }
        if (this.typeSpecificDataLength > 0) {
            System.arraycopy(this.typeSpecificData.getByteArray(), 0, byArray, 78, this.typeSpecificDataLength);
        }
        if (this.errorCorrectionDataLength > 0) {
            System.arraycopy(this.errorCorrectionData.getByteArray(), 0, byArray, 78 + this.typeSpecificDataLength, this.errorCorrectionDataLength);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 16);
        stringBuffer.append("\t ASF_Stream_Properties_Object  GUID\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 8);
        stringBuffer.append("\t\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 24, 16);
        stringBuffer.append("\t Stream Type  GUID : ");
        if (Arrays.equals(this.streamTypeGUID, AsfConstants.ASF_Video_Media)) {
            stringBuffer.append("ASF_Video_Media\n");
        } else if (Arrays.equals(this.streamTypeGUID, AsfConstants.ASF_Audio_Media)) {
            stringBuffer.append("ASF_Audio_Media\n");
        } else if (Arrays.equals(this.streamTypeGUID, AsfConstants.ASF_JFIF_Media)) {
            stringBuffer.append("ASF_JFIF_Media\n");
        } else {
            stringBuffer.append("Unknown\n");
        }
        AsfHeader.appendHexString(stringBuffer, byArray, 40, 16);
        stringBuffer.append("\t Error Correction Type  GUID : ");
        if (Arrays.equals(this.errorCorrectionTypeGUID, AsfConstants.ASF_No_Error_Correction)) {
            stringBuffer.append("ASF_No_Error_Correction\n");
        } else if (Arrays.equals(this.errorCorrectionTypeGUID, AsfConstants.ASF_Audio_Spread)) {
            stringBuffer.append("ASF_Audio_Spread\n");
        }
        AsfHeader.appendHexString(stringBuffer, byArray, 56, 8);
        stringBuffer.append("\t Time Offset : " + this.timeOffset + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 64, 4);
        stringBuffer.append("\t\t Type Spesific Data Length : " + this.typeSpecificDataLength + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 68, 4);
        stringBuffer.append("\t\t Error Correction Data Length : " + this.errorCorrectionDataLength + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 72, 2);
        stringBuffer.append("\t\t streamNumber : " + this.streamNumber + "\t encrypted : " + this.encrypted + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 74, 4);
        stringBuffer.append("\t\t reserved   ( may be 00 00 00 00 ) \n\n");
        if (this.typeSpecificDataLength > 0) {
            stringBuffer.append(this.typeSpecificData.dumpText());
        }
        if (this.errorCorrectionDataLength > 0) {
            stringBuffer.append(this.errorCorrectionData.dumpText());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

