/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfConstants;
import asf.AsfHeader;
import asf.AsfHeaderObject;
import java.util.Arrays;

class UnknownObject
extends AsfHeaderObject
implements AsfConstants {
    private int objectSize;
    private byte[] returnBytes;
    private byte[] unknownGUID = new byte[16];

    public UnknownObject(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.unknownGUID, 0, this.unknownGUID.length);
        this.objectSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
        this.returnBytes = new byte[this.objectSize];
        System.arraycopy(byArray, n, this.returnBytes, 0, this.objectSize);
    }

    int getObjectSize() {
        return this.objectSize;
    }

    byte[] getUnknownGUID() {
        return this.unknownGUID;
    }

    String getGUIDName() {
        if (Arrays.equals(this.unknownGUID, AsfConstants.ASF_Content_Encryption_Object)) {
            return "ASF_Content_Encryption_Object";
        }
        if (Arrays.equals(this.unknownGUID, AsfConstants.ASF_Extended_Content_Encryption_Object)) {
            return "ASF_Extended_Content_Encryption_Object";
        }
        if (Arrays.equals(this.unknownGUID, AsfConstants.ASF_Alt_Extended_Content_Encryption_Object)) {
            return "ASF_Alt_Extended_Content_Encryption_Object";
        }
        if (Arrays.equals(this.unknownGUID, AsfConstants.ASF_Digital_Signature_Object)) {
            return "ASF_Digital_Signature_Object";
        }
        if (Arrays.equals(this.unknownGUID, AsfConstants.ASF_Script_Command_Object)) {
            return "ASF_Script_Command_Object";
        }
        if (Arrays.equals(this.unknownGUID, AsfConstants.ASF_Marker_Object)) {
            return "ASF_Marker_Object";
        }
        return "----------";
    }

    byte[] getByteArray() {
        return this.returnBytes;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 0, 16);
        stringBuffer.append("\t UnknownObject : " + this.getGUIDName() + "\n");
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 16, 8);
        stringBuffer.append("\t objectSize  :  " + this.objectSize + " bytes\n");
        AsfHeader.appendHexString(stringBuffer, this.returnBytes, 16, this.objectSize - 24);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

