/*
 * Decompiled with CFR 0.152.
 */
package asf;

import asf.AsfHeader;
import asf.CodecSpecificData;

class WaveFormatEX {
    private int objectSize;
    private int formatTag;
    private int numberOfChannels;
    private int samplesPerSecond;
    private int averageNumberOfBytesPerSecond;
    private int blockAlignment;
    private int bitsPerSample;
    private int codecSpecificDataSize;
    private CodecSpecificData codecSpecificData;

    public WaveFormatEX() {
    }

    public WaveFormatEX(byte[] byArray, int n, int n2) {
        this.objectSize = n2;
        this.formatTag = (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
        this.numberOfChannels = (byArray[n + 2] & 0xFF) + ((byArray[n + 3] & 0xFF) << 8);
        this.samplesPerSecond = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
        this.averageNumberOfBytesPerSecond = (byArray[n + 8] & 0xFF) + ((byArray[n + 9] & 0xFF) << 8) + ((byArray[n + 10] & 0xFF) << 16) + ((byArray[n + 11] & 0xFF) << 24);
        this.blockAlignment = (byArray[n + 12] & 0xFF) + ((byArray[n + 13] & 0xFF) << 8);
        this.bitsPerSample = (byArray[n + 14] & 0xFF) + ((byArray[n + 15] & 0xFF) << 8);
        this.codecSpecificDataSize = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8);
        if (this.codecSpecificDataSize > 0) {
            this.codecSpecificData = new CodecSpecificData(byArray, n + 18, this.codecSpecificDataSize, this.formatTag);
        }
    }

    byte[] getByteArray() {
        byte[] byArray = new byte[this.objectSize];
        byArray[0] = (byte)this.formatTag;
        byArray[1] = (byte)(this.formatTag >> 8);
        byArray[2] = (byte)this.numberOfChannels;
        byArray[3] = (byte)(this.numberOfChannels >> 8);
        byArray[4] = (byte)this.samplesPerSecond;
        byArray[5] = (byte)(this.samplesPerSecond >> 8);
        byArray[6] = (byte)(this.samplesPerSecond >> 16);
        byArray[7] = (byte)(this.samplesPerSecond >> 24);
        byArray[8] = (byte)this.averageNumberOfBytesPerSecond;
        byArray[9] = (byte)(this.averageNumberOfBytesPerSecond >> 8);
        byArray[10] = (byte)(this.averageNumberOfBytesPerSecond >> 16);
        byArray[11] = (byte)(this.averageNumberOfBytesPerSecond >> 24);
        byArray[12] = (byte)this.blockAlignment;
        byArray[13] = (byte)(this.blockAlignment >> 8);
        byArray[14] = (byte)this.bitsPerSample;
        byArray[15] = (byte)(this.bitsPerSample >> 8);
        byArray[16] = (byte)this.codecSpecificDataSize;
        byArray[17] = (byte)(this.codecSpecificDataSize >> 8);
        if (this.codecSpecificDataSize > 0) {
            System.arraycopy(this.codecSpecificData.getByteArray(), 0, byArray, 18, this.codecSpecificDataSize);
        }
        return byArray;
    }

    String dumpText() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getByteArray();
        AsfHeader.appendHexString(stringBuffer, byArray, 0, 2);
        stringBuffer.append("\t Format Tag\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 2, 2);
        stringBuffer.append("\t Number of Channels : " + this.numberOfChannels + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 4, 4);
        stringBuffer.append("\t Samples Per Second : " + this.samplesPerSecond + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 8, 4);
        stringBuffer.append("\t Average Number of Bytes Per Second : " + this.averageNumberOfBytesPerSecond + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 12, 2);
        stringBuffer.append("\t Block Alignment : " + this.blockAlignment + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 14, 2);
        stringBuffer.append("\t Bits Per Sample : " + this.bitsPerSample + "\n");
        AsfHeader.appendHexString(stringBuffer, byArray, 16, 2);
        stringBuffer.append("\t Codec Specific Data Size : " + this.codecSpecificDataSize + "\n");
        if (this.codecSpecificDataSize > 0) {
            stringBuffer.append(this.codecSpecificData.dumpText());
        }
        return stringBuffer.toString();
    }

    void setFormatTag(String string) {
    }

    void setNumberOfChannels(int n) {
        this.numberOfChannels = n;
    }

    void setSamplesPerSecond(int n) {
        this.samplesPerSecond = n;
    }

    void setAverageNumberOfBytesPerSecond(int n) {
        this.averageNumberOfBytesPerSecond = n;
    }

    void setBlockAlignment(int n) {
        this.blockAlignment = n;
    }

    void setBitsPerSample(int n) {
        this.bitsPerSample = n;
    }

    void setCodecSpecificDataSize(int n) {
        this.codecSpecificDataSize = n;
    }

    String getCodecString() {
        String string = "";
        if (this.codecSpecificData != null) {
            string = this.codecSpecificData.getCodecString();
        }
        return string;
    }

    int getObjectSize() {
        return this.objectSize;
    }

    String getFormatTag() {
        return "";
    }

    int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    int getSamplesPerSecond() {
        return this.samplesPerSecond;
    }

    int getAverageNumberOfBytesPerSecond() {
        return this.averageNumberOfBytesPerSecond;
    }

    int getBlockAlignment() {
        return this.blockAlignment;
    }

    int getBitsPerSample() {
        return this.bitsPerSample;
    }

    int getCodecSpecificDataSize() {
        return this.codecSpecificDataSize;
    }
}

