/*
 * Decompiled with CFR 0.152.
 */
package avi;

import avi.AviFile;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class AviData {
    private BufferedInputStream bis;
    private AviFile aviFile;
    private int chunkSize;
    private int chunkType;
    private long aviDataSize;
    private long currentDataOffset;
    public static final int AUDIO = 1;
    public static final int VIDEO_KEYFRAME = 2;
    public static final int VIDEO_NON_KEY = 3;
    public static final int INDEX = 4;

    public AviData(AviFile aviFile) {
        this.aviFile = aviFile;
        this.prepareData();
    }

    void prepareData() {
        block7: {
            try {
                if (this.bis != null) {
                    this.bis.close();
                    this.bis = null;
                }
                this.bis = new BufferedInputStream(new FileInputStream(this.aviFile.getFile()));
                int n = this.aviFile.getHeaderSize();
                int n2 = (int)this.bis.skip(n);
                if (n2 != n) {
                    for (int i = 0; i < n - n2; ++i) {
                        this.bis.read();
                    }
                }
                this.bis.mark(8);
                while (true) {
                    byte[] byArray = new byte[4];
                    this.bis.read(byArray, 0, 4);
                    if ((byArray[0] & 0xFF) == 76 && (byArray[1] & 0xFF) == 73 && (byArray[2] & 0xFF) == 83 && (byArray[3] & 0xFF) == 84) {
                        this.bis.read(byArray, 0, 4);
                        this.aviDataSize = (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) + (long)((byArray[2] & 0xFF) << 16) + (long)((byArray[3] & 0xFF) << 24);
                        this.aviDataSize += 8L;
                        this.bis.read(byArray, 0, 4);
                        if ((byArray[0] & 0xFF) != 109 || (byArray[1] & 0xFF) != 111 || (byArray[2] & 0xFF) != 118 || (byArray[3] & 0xFF) != 105) continue;
                        this.bis.mark(8);
                        this.currentDataOffset = 4L;
                        break block7;
                    }
                    if ((byArray[0] & 0xFF) == 48 && (byArray[1] & 0xFF) == 49 && (byArray[2] & 0xFF) == 119 && (byArray[3] & 0xFF) == 98 || (byArray[0] & 0xFF) == 48 && (byArray[1] & 0xFF) == 48 && (byArray[2] & 0xFF) == 100 && (byArray[3] & 0xFF) == 98 || (byArray[0] & 0xFF) == 48 && (byArray[1] & 0xFF) == 48 && (byArray[2] & 0xFF) == 100 && (byArray[3] & 0xFF) == 99) break;
                }
                this.bis.reset();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    boolean hasNextChunk() {
        try {
            byte[] byArray = new byte[4];
            while (this.bis.read(byArray, 0, 4) != -1) {
                if ((byArray[0] & 0xFF) == 48 && (byArray[1] & 0xFF) == 49 && (byArray[2] & 0xFF) == 119 && (byArray[3] & 0xFF) == 98) {
                    this.chunkType = 1;
                    this.readChunkSize(byArray);
                    return true;
                }
                if ((byArray[0] & 0xFF) == 48 && (byArray[1] & 0xFF) == 48 && (byArray[2] & 0xFF) == 100 && (byArray[3] & 0xFF) == 98) {
                    this.chunkType = 2;
                    this.readChunkSize(byArray);
                    return true;
                }
                if ((byArray[0] & 0xFF) == 48 && (byArray[1] & 0xFF) == 48 && (byArray[2] & 0xFF) == 100 && (byArray[3] & 0xFF) == 99) {
                    this.chunkType = 3;
                    this.readChunkSize(byArray);
                    return true;
                }
                if ((byArray[0] & 0xFF) == 105 && (byArray[1] & 0xFF) == 100 && (byArray[2] & 0xFF) == 120 && (byArray[3] & 0xFF) == 49) {
                    this.chunkType = 4;
                    return false;
                }
                this.chunkType = 0;
                this.readChunkSize(byArray);
                this.skipChunkData();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return false;
    }

    private void readChunkSize(byte[] byArray) throws IOException {
        this.bis.read(byArray, 0, 4);
        this.chunkSize = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
    }

    byte[] getNextChunkArray() {
        byte[] byArray = new byte[this.chunkSize];
        try {
            this.bis.read(byArray, 0, this.chunkSize);
            this.currentDataOffset += (long)(this.chunkSize + 8);
            if (this.chunkSize % 2 != 0) {
                this.bis.read();
                ++this.currentDataOffset;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return byArray;
    }

    void skipChunkData() {
        try {
            long l = 0L;
            for (long i = (long)this.chunkSize; (l = this.bis.skip(i)) != i && l >= 0L; i -= l) {
            }
            this.currentDataOffset += (long)(this.chunkSize + 8);
            if (this.chunkSize % 2 != 0) {
                this.bis.read();
                ++this.currentDataOffset;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    long getDataSize() {
        return this.aviDataSize;
    }

    long getCurrentDataOffset() {
        return this.currentDataOffset;
    }

    int nextChunkSize() {
        return this.chunkSize;
    }

    int nextChunkType() {
        return this.chunkType;
    }

    int read() throws IOException {
        return this.bis.read();
    }

    void close() throws IOException {
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
    }
}

