/*
 * Decompiled with CFR 0.152.
 */
package avi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class AviHeader {
    private long fileSize;
    private int headerSize;
    private int streamCount;
    private String videoCodec = "---";
    private String audioCodec = "---";
    private int videoWidth;
    private int videoHeight;
    private long microSecPerFrame;
    private int videoFrameCount;
    private int audioDataRate;
    private byte[] bitmapInfoHeaderArray;
    private BufferedInputStream bis;
    private File srcFile;

    public AviHeader(File file) {
        this.srcFile = file;
    }

    boolean parseHeader() {
        try {
            this.bis = new BufferedInputStream(new FileInputStream(this.srcFile));
            this.bis.mark(8);
            byte[] byArray = new byte[4];
            this.bis.read(byArray, 0, 4);
            if ((byArray[0] & 0xFF) != 82 || (byArray[1] & 0xFF) != 73 || (byArray[2] & 0xFF) != 70 || (byArray[3] & 0xFF) != 70) {
                return false;
            }
            this.bis.read(byArray, 0, 4);
            this.fileSize = (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) + (long)((byArray[2] & 0xFF) << 16) + (long)((byArray[3] & 0xFF) << 24);
            this.bis.read(byArray, 0, 4);
            if ((byArray[0] & 0xFF) != 65 || (byArray[1] & 0xFF) != 86 || (byArray[2] & 0xFF) != 73 || (byArray[3] & 0xFF) != 32) {
                return false;
            }
            this.headerSize = 12;
            while (this.bis.read(byArray, 0, 4) != -1) {
                int n;
                if ((byArray[0] & 0xFF) == 76 && (byArray[1] & 0xFF) == 73 && (byArray[2] & 0xFF) == 83 && (byArray[3] & 0xFF) == 84) {
                    this.bis.read(byArray, 0, 4);
                    n = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
                    this.bis.read(byArray, 0, 4);
                    if ((byArray[0] & 0xFF) == 104 && (byArray[1] & 0xFF) == 100 && (byArray[2] & 0xFF) == 114 && (byArray[3] & 0xFF) == 108) {
                        byte[] byArray2 = new byte[n - 4];
                        this.bis.read(byArray2, 0, n - 4);
                        this.parseAviHeaderList(byArray2);
                        this.headerSize = this.headerSize + 8 + n;
                    } else if ((byArray[0] & 0xFF) == 73 && (byArray[1] & 0xFF) == 78 && (byArray[2] & 0xFF) == 70 && (byArray[3] & 0xFF) == 79) {
                        this.bis.skip(n - 4);
                        this.headerSize = this.headerSize + 8 + n;
                    } else {
                        if ((byArray[0] & 0xFF) == 109 && (byArray[1] & 0xFF) == 111 && (byArray[2] & 0xFF) == 118 && (byArray[3] & 0xFF) == 105) {
                            this.bis.reset();
                            break;
                        }
                        this.bis.skip(n - 4);
                    }
                } else if ((byArray[0] & 0xFF) == 74 && (byArray[1] & 0xFF) == 85 && (byArray[2] & 0xFF) == 78 && (byArray[3] & 0xFF) == 75) {
                    this.bis.read(byArray, 0, 4);
                    n = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
                    for (int i = 0; i < n; ++i) {
                        this.bis.read();
                    }
                    this.headerSize = this.headerSize + 8 + n;
                }
                this.bis.mark(8);
            }
            this.bis.close();
            this.bis = null;
        }
        catch (IOException iOException) {
            System.out.println("parseHeader() : " + iOException);
        }
        return true;
    }

    private void parseAviHeaderList(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            if ((byArray[n] & 0xFF) == 97 && (byArray[n + 1] & 0xFF) == 118 && (byArray[n + 2] & 0xFF) == 105 && (byArray[n + 3] & 0xFF) == 104) {
                n = n + 8 + this.parseAVIHeader(byArray, n);
                continue;
            }
            if ((byArray[n] & 0xFF) == 76 && (byArray[n + 1] & 0xFF) == 73 && (byArray[n + 2] & 0xFF) == 83 && (byArray[n + 3] & 0xFF) == 84) {
                n2 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
                if ((byArray[n + 8] & 0xFF) == 115 && (byArray[n + 9] & 0xFF) == 116 && (byArray[n + 10] & 0xFF) == 114 && (byArray[n + 11] & 0xFF) == 108) {
                    this.parseStreamHeaderList(byArray, n + 12, n + n2 + 8);
                }
                n = n + 8 + n2;
                continue;
            }
            if ((byArray[n] & 0xFF) != 74 || (byArray[n + 1] & 0xFF) != 85 || (byArray[n + 2] & 0xFF) != 78 || (byArray[n + 3] & 0xFF) != 75) continue;
            n2 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
            n = n + n2 + 8;
        }
    }

    private void parseStreamHeaderList(byte[] byArray, int n, int n2) {
        while (n2 > n) {
            int n3;
            if ((byArray[n] & 0xFF) == 115 && (byArray[n + 1] & 0xFF) == 116 && (byArray[n + 2] & 0xFF) == 114 && (byArray[n + 3] & 0xFF) == 104) {
                n += this.parseStreamHeader(byArray, n);
                continue;
            }
            if ((byArray[n] & 0xFF) == 74 && (byArray[n + 1] & 0xFF) == 85 && (byArray[n + 2] & 0xFF) == 78 && (byArray[n + 3] & 0xFF) == 75) {
                n3 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
                n = n + n3 + 8;
                continue;
            }
            n3 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
            n = n + n3 + 8;
        }
    }

    private int parseAVIHeader(byte[] byArray, int n) {
        int n2 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
        this.microSecPerFrame = (long)(byArray[n + 8] & 0xFF) + (long)((byArray[n + 9] & 0xFF) << 8) + (long)((byArray[n + 10] & 0xFF) << 16) + (long)((byArray[n + 11] & 0xFF) << 24);
        this.streamCount = byArray[n + 32] & 0xFF;
        return n2;
    }

    private int parseStreamHeader(byte[] byArray, int n) {
        int n2 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
        int n3 = 0;
        if ((byArray[n + 8] & 0xFF) == 118 && (byArray[n + 9] & 0xFF) == 105 && (byArray[n + 10] & 0xFF) == 100 && (byArray[n + 11] & 0xFF) == 115) {
            this.videoFrameCount = (byArray[n + 40] & 0xFF) + ((byArray[n + 41] & 0xFF) << 8) + ((byArray[n + 42] & 0xFF) << 16) + ((byArray[n + 43] & 0xFF) << 24);
            if ((byArray[n = n + n2 + 8] & 0xFF) == 115 && (byArray[n + 1] & 0xFF) == 116 && (byArray[n + 2] & 0xFF) == 114 && (byArray[n + 3] & 0xFF) == 102) {
                n3 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
                this.videoWidth = (byArray[n + 12] & 0xFF) + ((byArray[n + 13] & 0xFF) << 8) + ((byArray[n + 14] & 0xFF) << 16) + ((byArray[n + 15] & 0xFF) << 24);
                this.videoHeight = (byArray[n + 16] & 0xFF) + ((byArray[n + 17] & 0xFF) << 8) + ((byArray[n + 18] & 0xFF) << 16) + ((byArray[n + 19] & 0xFF) << 24);
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, n + 24, byArray2, 0, 4);
                this.videoCodec = new String(byArray2);
                this.bitmapInfoHeaderArray = new byte[n3];
                System.arraycopy(byArray, n + 8, this.bitmapInfoHeaderArray, 0, n3);
            }
        } else if ((byArray[n + 8] & 0xFF) == 97 && (byArray[n + 9] & 0xFF) == 117 && (byArray[n + 10] & 0xFF) == 100 && (byArray[n + 11] & 0xFF) == 115) {
            this.audioDataRate = (byArray[n + 32] & 0xFF) + ((byArray[n + 33] & 0xFF) << 8) + ((byArray[n + 34] & 0xFF) << 16) + ((byArray[n + 35] & 0xFF) << 24);
            if ((byArray[n = n + n2 + 8] & 0xFF) == 115 && (byArray[n + 1] & 0xFF) == 116 && (byArray[n + 2] & 0xFF) == 114 && (byArray[n + 3] & 0xFF) == 102) {
                n3 = (byArray[n + 4] & 0xFF) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
                if ((byArray[n + 8] & 0xFF) == 85 && (byArray[n + 9] & 0xFF) == 0) {
                    this.audioCodec = "MP3";
                } else if ((byArray[n + 8] & 0xFF) == 0 && (byArray[n + 9] & 0xFF) == 0) {
                    this.audioCodec = "PCM";
                } else if ((byArray[n + 8] & 0xFF) == 1 && (byArray[n + 9] & 0xFF) == 0) {
                    this.audioCodec = "PCM";
                } else if ((byArray[n + 8] & 0xFF) == 3 && (byArray[n + 9] & 0xFF) == 0) {
                    this.audioCodec = "PCM";
                } else if ((byArray[n + 8] & 0xFF) == 0 && (byArray[n + 9] & 0xFF) == 32) {
                    this.audioCodec = "AC3";
                } else if ((byArray[n + 8] & 0xFF) == 255 && (byArray[n + 9] & 0xFF) == 0) {
                    this.audioCodec = "AAC";
                } else {
                    byte[] byArray3 = new byte[]{byArray[n + 9], byArray[n + 8]};
                    this.audioCodec = this.getAudioCodecString(byArray3);
                }
            }
        }
        return n2 + n3 + 16;
    }

    String getVideoCodec() {
        return this.videoCodec;
    }

    String getAudioCodec() {
        return this.audioCodec;
    }

    byte[] getBitmapInfoHeaderArray() {
        return this.bitmapInfoHeaderArray;
    }

    private String getAudioCodecString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("wFormatTag : 0x");
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            n = byArray[i] & 0xFF;
            if (n <= 15) {
                stringBuffer.append("0" + Integer.toHexString(n).toUpperCase());
                continue;
            }
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
        }
        return stringBuffer.toString();
    }

    long getMicroSecPerFrame() {
        return this.microSecPerFrame;
    }

    int getVideoWidth() {
        return this.videoWidth;
    }

    int getVideoHeight() {
        return this.videoHeight;
    }

    int getHeaderSize() {
        return this.headerSize;
    }

    long getPlayTimeMilliSec() {
        return (long)this.videoFrameCount * this.microSecPerFrame / 1000L;
    }

    int getAudioDataRate() {
        return this.audioDataRate;
    }

    int getVideoFrameCount() {
        return this.videoFrameCount;
    }

    long getFileSize() {
        return this.fileSize;
    }
}

