/*
 * Decompiled with CFR 0.152.
 */
package avi;

import avi.AviFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class AviIndex {
    private AviFile aviFile;
    private File file;
    private long indexOffset;
    private long indexSize;
    private boolean hasIndex;
    private byte[] buffer = new byte[16];
    private int chunkType;
    private boolean isKeyFrame;
    private long dataOffset;
    private int chunkSize;
    private BufferedInputStream bis;

    public AviIndex(AviFile aviFile) throws IOException {
        this.aviFile = aviFile;
        this.prepareIndex();
    }

    void prepareIndex() throws IOException {
        long l = this.aviFile.getHeaderSize();
        long l2 = this.aviFile.getDataSize();
        this.file = this.aviFile.getFile();
        long l3 = this.file.length();
        this.indexOffset = l + l2;
        if (l3 <= this.indexOffset) {
            this.hasIndex = false;
            return;
        }
        this.bis = new BufferedInputStream(new FileInputStream(this.file));
        this.bis.skip(this.indexOffset);
        byte[] byArray = new byte[4];
        this.bis.read(byArray);
        if ((byArray[0] & 0xFF) != 105 || (byArray[1] & 0xFF) != 100 || (byArray[2] & 0xFF) != 120 || (byArray[3] & 0xFF) != 49) {
            this.hasIndex = false;
            return;
        }
        this.hasIndex = true;
        this.bis.read(byArray);
        this.indexSize = (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) + (long)((byArray[2] & 0xFF) << 16) + (long)((byArray[3] & 0xFF) << 24);
    }

    void nextIndex() {
        try {
            if (this.bis.read(this.buffer) != -1) {
                this.isKeyFrame = (this.buffer[4] & 0xFF) == 16;
                this.dataOffset = (long)(this.buffer[8] & 0xFF) + (long)((this.buffer[9] & 0xFF) << 8) + (long)((this.buffer[10] & 0xFF) << 16) + (long)((this.buffer[11] & 0xFF) << 24);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean hasIndex() {
        return this.hasIndex;
    }

    boolean isKeyFrame() {
        return this.isKeyFrame;
    }

    long getDataOffset() {
        return this.dataOffset;
    }
}

