/*
 * Decompiled with CFR 0.152.
 */
package wmv3server;

import asf.AsfFile;
import asf.AsfPacketizer;
import asf.AsfStream;
import asf.BitmapInfoHeader;
import asf.MediaObject;
import avi.AviFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import wmv3server.WMV3Server;

class Avi2AsfMp3Converter
implements Runnable {
    private AviFile aviFile;
    private AsfFile asfFile;
    private File mp3File;
    private WMV3Server wmvServer;
    private BufferedOutputStream bos;
    private AsfStream videoStream;
    private AsfStream audioStream;
    private MediaObject mo_video;
    private MediaObject mo_audio;
    private AsfPacketizer packetizer;
    private boolean convertVideo = true;
    private boolean convertAudio = true;
    private long presentationTimeMicroSec;
    private long frameIntervalMicroSec;
    private int preroll;
    private int packetSize;
    private int duration;
    private long maxDataRate;

    public Avi2AsfMp3Converter(AviFile aviFile, AsfFile asfFile, File file, WMV3Server wMV3Server) {
        this.aviFile = aviFile;
        this.asfFile = asfFile;
        if (file == null) {
            this.convertAudio = false;
        } else {
            this.mp3File = file;
        }
        this.wmvServer = wMV3Server;
        this.preroll = 3000;
        this.presentationTimeMicroSec += (long)(this.preroll * 1000);
        this.frameIntervalMicroSec = aviFile.getMicroSecPerFrame();
        this.createPacketSize(aviFile.getVideoDataRate());
        asfFile.setPacketSize(this.packetSize);
        asfFile.setDuration(this.duration);
        asfFile.setPreroll(this.preroll);
        asfFile.setNewFileID();
        if (this.convertVideo) {
            this.videoStream = new AsfStream(1);
            this.videoStream.setCodec(aviFile.getVideoCodec());
            this.videoStream.setWidth(aviFile.getWidth());
            this.videoStream.setHeight(aviFile.getHeight());
            this.mo_video = new MediaObject();
            this.mo_video.setStreamNumber(1);
            this.videoStream.setMediaObject(this.mo_video);
            asfFile.addAsfStream(this.videoStream);
            BitmapInfoHeader bitmapInfoHeader = this.createBitmapInfoHeader(aviFile.getBitmapInfoHeaderArray());
            if (bitmapInfoHeader != null) {
                asfFile.setBitmapInfoHeader(bitmapInfoHeader);
            }
        }
        if (this.convertAudio) {
            try {
                this.bos = new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        this.packetizer = new AsfPacketizer(asfFile);
        asfFile.createCodecList();
        asfFile.createNewFile();
    }

    public void run() {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.wmvServer.showCompleteTextAsfProgressBar(false);
        while (this.aviFile.hasNextChunk()) {
            byte[] byArray;
            int n3 = this.aviFile.nextChunkType();
            if (n3 == 2 || n3 == 3) {
                ++n;
                if (this.convertVideo) {
                    byArray = this.aviFile.getNextChunkArray();
                    this.mo_video.setDataArray(byArray);
                    this.mo_video.setPresentationTime(this.presentationTimeMicroSec / 1000L);
                    if (n3 == 2) {
                        this.mo_video.setKeyFrame(true);
                        long l4 = this.presentationTimeMicroSec - l3;
                        l = l2 * 8L * 1000000L / l4;
                        if (l > this.maxDataRate && l4 > 3000000L) {
                            this.maxDataRate = l;
                        }
                        l3 = this.presentationTimeMicroSec;
                        l2 = byArray.length;
                    } else {
                        this.mo_video.setKeyFrame(false);
                    }
                    if (byArray.length != 0) {
                        this.packetizer.addMediaObject(this.mo_video);
                        this.mo_video.countUpMediaObjectNumber();
                        l2 += (long)byArray.length;
                        this.wmvServer.setAsfProgressBarValue(n);
                    }
                    this.presentationTimeMicroSec += this.frameIntervalMicroSec;
                    continue;
                }
                this.aviFile.skipChunkData();
                continue;
            }
            if (n3 != 1) continue;
            ++n2;
            if (this.convertAudio) {
                byArray = this.aviFile.getNextChunkArray();
                this.writeMP3(byArray);
                continue;
            }
            this.aviFile.skipChunkData();
        }
        this.packetizer.flush();
        this.asfFile.terminateFile();
        this.rewriteHeader();
        if (this.convertAudio) {
            this.closeMP3();
        }
        this.wmvServer.showCompleteTextAsfProgressBar(true);
        this.wmvServer.convertFinished(this.convertAudio);
    }

    private void writeMP3(byte[] byArray) {
        try {
            this.bos.write(byArray);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void closeMP3() {
        try {
            this.bos.flush();
            this.bos.close();
            this.bos = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void createPacketSize(long l) {
        if (l < 50000L) {
            this.duration = 200;
        } else if (l >= 50000L && l < 100000L) {
            this.duration = 150;
        } else if (l >= 100000L && l < 500000L) {
            this.duration = 100;
        } else if (l >= 500000L && l < 1000000L) {
            this.duration = 66;
        } else if (l >= 1000000L) {
            this.duration = 33;
        }
        this.packetSize = (int)l * this.duration / 8000 + 37;
    }

    private BitmapInfoHeader createBitmapInfoHeader(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = 44;
        if (byArray.length > n) {
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)(n >> 8 * i);
            }
        }
        BitmapInfoHeader bitmapInfoHeader = new BitmapInfoHeader(byArray, 0, n);
        return bitmapInfoHeader;
    }

    private void rewriteHeader() {
        int n = this.asfFile.getPacketCount();
        long l = (long)this.asfFile.getHeaderLength() + 50L + (long)n * (long)this.packetSize;
        this.asfFile.setFileSize(l);
        this.asfFile.setTotalPacketsCount(n);
        this.asfFile.setSendDuration();
        this.asfFile.setPlayDuration(this.presentationTimeMicroSec * 10L);
        this.asfFile.setMaximumBitrate((int)this.maxDataRate);
        if (this.maxDataRate == 0L) {
            this.asfFile.setMaximumBitrate((int)this.aviFile.getVideoDataRate());
        }
        this.asfFile.setAsfDataObjectSize((long)n * (long)this.packetSize + 50L);
        this.asfFile.rewriteHeader();
    }
}

