/*
 * Decompiled with CFR 0.152.
 */
package wmv3server;

import asf.AsfCallback;
import asf.AsfFile;
import asf.MMSServer;
import avi.AviFile;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import wmv3server.Avi2AsfMp3Converter;
import wmv3server.MP3Player;
import wmv3server.WMV3ServerGUI;

class WMV3Server
implements AsfCallback {
    private MMSServer server;
    private MP3Player mp3Player = new MP3Player();
    private WMV3ServerGUI gui = new WMV3ServerGUI(this, this.mp3Player);
    private boolean sourceFileExist;
    private AviFile aviFile;
    private AsfFile asfFile;
    private File mp3File;
    private Preferences pref = Preferences.userNodeForPackage(this.getClass());
    private static final String posX = "posX";
    private static final String posY = "posY";
    private static final String vol = "vol";

    public WMV3Server() {
        this.loadPrefs();
        this.gui.setVisible(true);
        this.server = new MMSServer(1755);
        this.server.setMediaPlayer(this.mp3Player);
        this.server.setCallBack(this);
    }

    public static void main(String[] stringArray) {
        new WMV3Server();
    }

    void openAVI(File file) {
        this.server.closeSession();
        this.mp3Player.disposeMovie();
        this.deleteTempFiles();
        this.closeAviFile();
        this.aviFile = new AviFile(file);
        this.showCompleteTextAsfProgressBar(false);
        if (this.aviFile.isValidAviFile()) {
            this.sourceFileExist = true;
            this.gui.setToolTipTextToFileLabel(file.getAbsolutePath());
            this.gui.setTextToVideoCodecLabel(this.aviFile.getVideoCodec());
            this.gui.setTextToAudioCodecLabel(this.aviFile.getAudioCodec());
            this.gui.setMaximumForAsfCreationBar(this.aviFile.getVideoFrameCount());
            this.gui.setValueForAsfCreationBar(0);
            if (this.aviFile.getVideoCodec().equals("WMV3") && this.aviFile.getAudioCodec().equals("MP3")) {
                this.gui.setCreateAsfButtonEnabled(true);
                this.gui.setCreateAsfMenuEnabled(true);
                this.gui.setTextToMessageLabel("Ready to Start");
            } else if (this.aviFile.getVideoCodec().equals("WMV3")) {
                this.gui.setCreateAsfButtonEnabled(false);
                this.gui.setCreateAsfMenuEnabled(true);
                this.gui.setTextToMessageLabel("WMV3 with MP3 AVI is only available");
            } else {
                this.gui.setCreateAsfButtonEnabled(false);
                this.gui.setCreateAsfMenuEnabled(false);
                this.gui.setTextToMessageLabel("WMV3 with MP3 AVI is only available");
            }
        } else if (!this.aviFile.isValidAviFile()) {
            this.gui.showAlert("This is not an AVI File!");
            this.aviFile = null;
            file = null;
            this.gui.setTextToFileLabel("");
            this.gui.setToolTipTextToFileLabel("");
            this.gui.setTextToVideoCodecLabel("---");
            this.gui.setTextToAudioCodecLabel("---");
            this.gui.setCreateAsfButtonEnabled(false);
            this.gui.setCreateAsfMenuEnabled(false);
        }
    }

    void createAsf() {
        AsfFile asfFile = new AsfFile();
        File file = this.createNewFileToSameDirectory(this.aviFile.getFile());
        asfFile.setNewFile(file);
        Avi2AsfMp3Converter avi2AsfMp3Converter = new Avi2AsfMp3Converter(this.aviFile, asfFile, null, this);
        Thread thread = new Thread(avi2AsfMp3Converter);
        thread.start();
        this.gui.setTextToMessageLabel("");
    }

    void createAsfMP3() {
        this.asfFile = new AsfFile();
        File file = this.createNewFile(".asf");
        this.asfFile.setNewFile(file);
        this.mp3File = this.createNewFile(".mp3");
        Avi2AsfMp3Converter avi2AsfMp3Converter = new Avi2AsfMp3Converter(this.aviFile, this.asfFile, this.mp3File, this);
        this.gui.setOpenButtonEnabled(false);
        this.gui.setCreateAsfButtonEnabled(false);
        this.gui.setOpenButtonEnabled(false);
        this.gui.setCreateAsfMenuEnabled(false);
        Thread thread = new Thread(avi2AsfMp3Converter);
        thread.start();
        this.gui.setTextToMessageLabel("Creating temp files now ...");
    }

    void convertFinished(boolean bl) {
        if (!bl) {
            this.gui.setTextToMessageLabel("");
            return;
        }
        this.asfFile = new AsfFile(this.asfFile.getNewFile());
        this.setAsfFile(this.asfFile);
        this.setMP3File(this.mp3File);
        if (!this.server.isServerStarted()) {
            this.server.prepareServer();
        }
        this.server.listenForConnection();
        this.showCompleteTextAsfProgressBar(false);
        this.setAsfProgressBarValue(0);
        this.gui.setStopButtonEnabled(true);
        this.gui.setTextToMessageLabel("Server started");
    }

    void doShutdownTask() {
        this.server.closeSession();
        this.mp3Player.disposeMovie();
        this.closeAviFile();
        this.deleteTempFiles();
    }

    void deleteTempFiles() {
        File file = null;
        if (this.asfFile == null) {
            return;
        }
        file = this.asfFile.getFile();
        if (file != null || file.exists()) {
            file.delete();
        }
        if (this.mp3File != null && this.mp3File.exists()) {
            this.mp3File.delete();
        }
    }

    public void closeAviFile() {
        try {
            if (this.aviFile != null) {
                this.aviFile.closeFile();
                this.aviFile = null;
            }
        }
        catch (IOException iOException) {
            this.gui.showAlert(iOException);
        }
    }

    private File createNewFile(String string) {
        File file = null;
        String string2 = System.getProperty("user.home");
        int n = 1;
        String string3 = "temp";
        String string4 = string2 + "/" + string3 + string;
        while ((file = new File(string4)).exists()) {
            string4 = string2 + "/" + string3 + "-" + n + string;
            ++n;
        }
        return file;
    }

    private File createNewFileToSameDirectory(File file) {
        File file2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
        int n = 1;
        String string = stringTokenizer.nextToken();
        String string2 = file.getParent() + "/" + string + ".asf";
        while ((file2 = new File(string2)).exists()) {
            string2 = file.getParent() + "/" + string + "-" + n + ".asf";
            ++n;
        }
        return file2;
    }

    void setAsfProgressBarValue(int n) {
        this.gui.setValueForAsfCreationBar(n);
    }

    void showCompleteTextAsfProgressBar(boolean bl) {
        this.gui.showCompleteTextAsfCreationBar(bl);
    }

    void setCreateAsfButtonEnabled(boolean bl) {
        this.gui.setCreateAsfButtonEnabled(bl);
    }

    void setAsfFile(AsfFile asfFile) {
        this.server.setAsfFile(asfFile);
    }

    void setMP3File(File file) {
        this.mp3Player.setMP3File(file);
    }

    public void startServer() {
        this.server.stopServer(false);
        Thread thread = new Thread(this.server);
        thread.start();
    }

    void stopServer() {
        this.server.stopServer(true);
        this.mp3Player.stop();
        this.gui.setTextToMessageLabel("Server stopped");
        this.gui.setOpenButtonEnabled(true);
        this.gui.setStopButtonEnabled(false);
        this.gui.setOpenButtonEnabled(true);
        this.gui.setCreateAsfMenuEnabled(true);
    }

    public void setDataRate(int n) {
    }

    public void savePrefs() {
        try {
            this.pref.putInt(posX, this.gui.getX());
            this.pref.putInt(posY, this.gui.getY());
            this.pref.putInt(vol, this.mp3Player.getVolumeSliderValue());
            this.pref.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void loadPrefs() {
        int n = this.pref.getInt(posX, 0);
        int n2 = this.pref.getInt(posY, 0);
        this.gui.setLocation(n, n2);
        int n3 = this.pref.getInt(vol, 80);
        this.mp3Player.setVolumeSliderValue(n3);
    }
}

